# -*- coding: binary -*-

#
# This class acts as standalone authenticator for Kerberos
#
class Msf::Exploit::Remote::Kerberos::ServiceAuthenticator::MSSQL < Msf::Exploit::Remote::Kerberos::ServiceAuthenticator::Base
  # @!attribute [r] mssql_port
  #   @return [Integer] the mssql port
  attr_reader :mssql_port

  def initialize(
    mssql_port: 1433,
    **kwargs
  )
    @mssql_port = mssql_port
    super(**kwargs)
  end

  def build_spn(options = {})
    Rex::Proto::Kerberos::Model::PrincipalName.new(
      name_type: Rex::Proto::Kerberos::Model::NameType::NT_SRV_INST,
      name_string: [
        'MSSQLSvc',
        "#{options.fetch(:hostname) { hostname }}:#{options.fetch(:mssql_port, mssql_port)}"
      ]
    )
  end
end
