/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.control;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnRunIssuesUtils;
import org.zaproxy.zap.control.ZapRelease;
import org.zaproxy.zap.utils.ZapXmlConfiguration;

public class AddOnCollection {
    private static final Logger LOGGER = LogManager.getLogger(AddOnCollection.class);
    private ZapRelease zapRelease = null;
    private List<AddOn> addOns = new ArrayList<AddOn>();
    private List<String> mandatoryAddOns = List.of();
    private File downloadDir = new File(Constant.FOLDER_LOCAL_PLUGIN);
    private Platform platform;

    public AddOnCollection(ZapXmlConfiguration config, Platform platform) {
        this(config, platform, true);
    }

    public AddOnCollection(ZapXmlConfiguration config, Platform platform, boolean allowAddOnsWithDependencyIssues) {
        this.platform = platform;
        this.load(config);
        if (!allowAddOnsWithDependencyIssues) {
            ArrayList<AddOn> checkedAddOns = new ArrayList<AddOn>(this.addOns);
            ArrayList<AddOn> runnableAddOns = new ArrayList<AddOn>(this.addOns.size());
            while (!checkedAddOns.isEmpty()) {
                AddOn addOn = (AddOn)checkedAddOns.remove(0);
                AddOn.AddOnRunRequirements requirements = addOn.calculateInstallRequirements(this.addOns);
                if (requirements.hasDependencyIssue()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Ignoring add-on {} because of dependency issue: {}", (Object)addOn.getName(), (Object)AddOnRunIssuesUtils.getDependencyIssue(requirements));
                    }
                    if (AddOn.BaseRunRequirements.DependencyIssue.CYCLIC != requirements.getDependencyIssue()) continue;
                    Set cyclicChain = (Set)requirements.getDependencyIssueDetails().get(0);
                    checkedAddOns.removeAll(cyclicChain);
                    continue;
                }
                if (requirements.hasExtensionsWithRunningIssues()) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("Ignoring add-on {} because of dependency issue in an extension: {}", (Object)addOn.getName(), (Object)AddOnRunIssuesUtils.getDependencyIssue(requirements));
                    continue;
                }
                runnableAddOns.add(addOn);
            }
            this.addOns = runnableAddOns;
        }
    }

    private void load(ZapXmlConfiguration config) {
        try {
            String version = config.getString("core.version");
            if (Platform.daily.equals((Object)this.platform)) {
                version = config.getString("core.daily-version", version);
            } else if (Constant.isKali()) {
                version = config.getString("core.kali-version", version);
            }
            if (version != null && version.length() > 0) {
                String relUrlStr = config.getString("core.relnotes-url", null);
                URL relUrl = null;
                if (relUrlStr != null) {
                    relUrl = new URI(relUrlStr).toURL();
                }
                String platformPrefix = "core." + this.platform.name() + ".";
                this.zapRelease = new ZapRelease(version, new URI(config.getString(platformPrefix + "url")).toURL(), config.getString(platformPrefix + "file"), config.getLong(platformPrefix + "size"), config.getString("core.relnotes"), relUrl, config.getString(platformPrefix + "hash"));
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        try {
            String[] addOnIds;
            for (String id : addOnIds = config.getStringArray("addon")) {
                AddOn ao;
                LOGGER.debug("Found add-on {}", (Object)id);
                try {
                    ao = new AddOn(id, this.downloadDir, config.configurationAt("addon_" + id));
                    ao.setInstallationStatus(AddOn.InstallationStatus.AVAILABLE);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to create add-on for {}", (Object)id, (Object)e);
                    continue;
                }
                if (ao.canLoadInCurrentVersion()) {
                    this.addAddOnImpl(ao);
                    continue;
                }
                LOGGER.debug("Ignoring add-on {} can't load in this version", (Object)ao.getName());
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public AddOnCollection(File[] dirs) {
        if (dirs != null) {
            for (File dir : dirs) {
                try {
                    this.addDirectory(dir);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void addDirectory(File dir) throws Exception {
        if (dir == null) {
            LOGGER.error("Null directory supplied");
            return;
        }
        if (!dir.exists()) {
            LOGGER.warn("Skipping enumeration of add-ons, the directory does not exist: {}", (Object)dir.getAbsolutePath());
            return;
        }
        if (!dir.isDirectory()) {
            LOGGER.warn("Not a directory: {}", (Object)dir.getAbsolutePath());
            return;
        }
        try (DirectoryStream<Path> addOnFiles = Files.newDirectoryStream(dir.toPath(), "*.zap");){
            for (Path addOnFile : addOnFiles) {
                AddOn.createAddOn(addOnFile).ifPresent(ao -> {
                    boolean add = true;
                    for (AddOn addOn : this.addOns) {
                        if (!ao.isSameAddOn(addOn)) continue;
                        if (ao.isUpdateTo(addOn)) {
                            if (ao.canLoadInCurrentVersion()) {
                                LOGGER.debug("Add-on {} version {} superseded by {}", (Object)addOn.getId(), (Object)addOn.getVersion(), (Object)ao.getVersion());
                                this.addOns.remove(addOn);
                                break;
                            }
                            LOGGER.debug("Ignoring newer add-on {} version {} because of ZAP version constraints; Not before={} Not from={} Current Version={}", (Object)ao.getId(), (Object)ao.getVersion(), (Object)ao.getNotBeforeVersion(), (Object)ao.getNotFromVersion(), (Object)Constant.PROGRAM_VERSION);
                            add = false;
                            break;
                        }
                        LOGGER.debug("Add-on {} version {} not latest.", (Object)ao.getId(), (Object)ao.getVersion());
                        add = false;
                        break;
                    }
                    if (add) {
                        LOGGER.debug("Found add-on {} version {}", (Object)ao.getId(), (Object)ao.getVersion());
                        this.addAddOnImpl((AddOn)ao);
                    }
                });
            }
        }
    }

    public List<AddOn> getAddOns() {
        return this.addOns;
    }

    public List<AddOn> getInstalledAddOns() {
        ArrayList<AddOn> installedAddOns = new ArrayList<AddOn>(this.addOns.size());
        for (AddOn addOn : this.addOns) {
            if (AddOn.InstallationStatus.INSTALLED != addOn.getInstallationStatus()) continue;
            installedAddOns.add(addOn);
        }
        return installedAddOns;
    }

    public AddOn getAddOn(String id) {
        for (AddOn addOn : this.addOns) {
            if (!addOn.getId().equals(id)) continue;
            return addOn;
        }
        return null;
    }

    public List<AddOn> getUpdatedAddOns(AddOnCollection aoc) {
        ArrayList<AddOn> updatedAddOns = new ArrayList<AddOn>();
        for (AddOn ao : aoc.getAddOns()) {
            for (AddOn addOn : this.addOns) {
                try {
                    if (!ao.isSameAddOn(addOn) || !ao.isUpdateTo(addOn)) continue;
                    updatedAddOns.add(ao);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return updatedAddOns;
    }

    public List<AddOn> getNewAddOns(AddOnCollection aoc) {
        ArrayList<AddOn> newAddOns = new ArrayList<AddOn>();
        for (AddOn ao : aoc.getAddOns()) {
            boolean isNew = true;
            for (AddOn addOn : this.addOns) {
                try {
                    if (!ao.isSameAddOn(addOn)) continue;
                    isNew = false;
                    break;
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            if (!isNew) continue;
            newAddOns.add(ao);
        }
        return newAddOns;
    }

    public ZapRelease getZapRelease() {
        return this.zapRelease;
    }

    public boolean includesAddOn(String id) {
        boolean inc = false;
        for (AddOn addOn : this.addOns) {
            if (!addOn.getId().equals(id)) continue;
            return true;
        }
        return inc;
    }

    public boolean addAddOn(AddOn ao) {
        if (this.includesAddOn(ao.getId())) {
            return false;
        }
        this.addAddOnImpl(ao);
        return true;
    }

    private void addAddOnImpl(AddOn ao) {
        ao.setMandatory(this.mandatoryAddOns.contains(ao.getId()));
        this.addOns.add(ao);
    }

    public boolean removeAddOn(AddOn ao) {
        for (AddOn addOn : this.addOns) {
            if (!addOn.getId().equals(ao.getId())) continue;
            this.addOns.remove(addOn);
            return true;
        }
        return false;
    }

    public void setMandatoryAddOns(List<String> mandatoryAddOns) {
        this.mandatoryAddOns = Objects.requireNonNull(mandatoryAddOns);
        mandatoryAddOns.forEach(id -> {
            AddOn addOn = this.getAddOn((String)id);
            if (addOn == null) {
                String message = "The mandatory add-on was not found: " + id + "\nRefer to https://www.zaproxy.org/docs/developer/ if you are building ZAP from source.";
                LOGGER.error(message);
                throw new IllegalStateException(message);
            }
            addOn.setMandatory(true);
        });
    }

    public static enum Platform {
        daily,
        windows,
        linux,
        mac;

    }
}

