/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Spicebird code.
 *
 * The Initial Developer of the Original Code is
 * Synovel Software Technologies
 * Portions created by the Initial Developer are Copyright (C) 2008
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Prasad Sunkari <prasad@synovel.com> (Original Author)
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef _csTelepathyMacros_H_
#define _csTelepathyMacros_H_

/*
 * Some magic here to support only those
 * interfaces that are supported by this object on DBus
 * NS_IMPL_ISUPPORTS uses NS_INTERFACE_TABLE_TAIL to
 * return the status of the QueryInterface.
 */

#define CS_TELEPATHY_INTERFACE_LIST_BEGIN                       \
  if (NS_SUCCEEDED(rv)) {                                       \
    char *dbusInterfaceName = NULL;

#define CS_TELEPATHY_INTERFACE_ITEM(_interface, _name)          \
    if (aIID.Equals(NS_GET_IID(_interface))) {                  \
      dbusInterfaceName = _name;                                \
      goto _csInterfaceCheck;                                   \
    }

#define CS_TELEPATHY_INTERFACE_LIST_END                         \
    goto _csSkipInterfaceCheck;                                 \
                                                                \
_csInterfaceCheck:                                              \
    rv = SupportsInterface((const char *)dbusInterfaceName);    \
  } /* NS_SUCCEEDED */                                          \
                                                                \
_csSkipInterfaceCheck:                                          \
  return rv;                                                    \
} /* End of QueryInterface Function */

#ifdef NS_INTERFACE_TABLE_TAIL
  #undef NS_INTERFACE_TABLE_TAIL
#endif


/*
 * Templates for the common callback types
 * Empty, Integer, String, IntegerList, StringList
 *
 * _type_: The interface/proxy/type of telepathy-glib object
 * _cmd_ : In most cases the DBus command
 *
 * Eg: For csITPPresenceClearStatusCB, Presence is the _type_
 *     and ClearStatus is the command to which the given
 *     interface is a callback.
 *
 * Note: Use of these macros required CS_TELEPATHY_PROXY_TYPE to
 *       be defined and equal to the proxy type that will be the
 *       first argument of the callbacks.
 */

/*
 * Macro to check error in the callbacks and pass the
 * error value to the callback interface. Pass "" as
 * first argument for the legacy implementation part
 */
#define CS_TELEPATHY_CALLBACK_CHECK_ERROR(_cmd_,_callback_,_error_)           \
  if (_error_ != NULL) {                                                      \
    _callback_->On##_cmd_##Error(_error_->code);                              \
    return;                                                                   \
  }                                                                            

/*
 * Define an empty callback.  Empty callbacks don't pass any value
 * to the callback interface.  They only indicate completion of a request
 */
#define CS_TELEPATHY_EMPTY_CALLBACK(_type_,_cmd_)                             \
static void                                                                   \
_cmd_##Response(CS_TELEPATHY_PROXY_TYPE *proxy, const GError *error,          \
                  gpointer user_data, GObject *unused)                        \
{                                                                             \
  csITP##_type_##_cmd_##CB *callback = (csITP##_type_##_cmd_##CB *)user_data; \
                                                                              \
  CS_TELEPATHY_CALLBACK_CHECK_ERROR(_cmd_,callback,error);                    \
  callback->On##_cmd_##Complete();                                            \
  NS_IF_RELEASE(callback);                                                    \
}                                                                              
                                                                               
/*
 * Define an uint callback.  Integer callbacks are used to
 * return an unsigned integer as the result of the invoked call
 */
#define CS_TELEPATHY_UINT_CALLBACK(_type_,_cmd_)                              \
static void                                                                   \
_cmd_##Response(CS_TELEPATHY_PROXY_TYPE *proxy, guint aIntParam,              \
                const GError *error, gpointer user_data, GObject *unused)     \
{                                                                             \
  csITP##_type_##_cmd_##CB *callback = (csITP##_type_##_cmd_##CB *)user_data; \
                                                                              \
  CS_TELEPATHY_CALLBACK_CHECK_ERROR(_cmd_,callback,error);                    \
  callback->On##_cmd_##Result(aIntParam);                                     \
  NS_IF_RELEASE(callback);                                                    \
}                                                                              
                                                                               
/*
 * Define an string list callback.  String list callbacks 
 * are used to return an nsIArray of nsIVariant wrapped strings 
 * as the result of the invoked call
 */
#define CS_TELEPATHY_STRING_LIST_CALLBACK(_type_,_cmd_)                       \
static void                                                                   \
_cmd_##Response(CS_TELEPATHY_PROXY_TYPE *cm, const char **strList,            \
                const GError *error, gpointer user_data, GObject *unused)     \
{                                                                             \
  csITP##_type_##_cmd_##CB *callback = (csITP##_type_##_cmd_##CB *)user_data; \
                                                                              \
  CS_TELEPATHY_CALLBACK_CHECK_ERROR(_cmd_,callback,error);                    \
                                                                              \
  char **str = (char **)(strList);                                            \
  nsCOMPtr<nsIWritableVariant> wrapper;                                       \
  nsCOMPtr<nsIMutableArray> array = do_CreateInstance(NS_ARRAY_CONTRACTID);   \
  while (*str != NULL) {                                                      \
    wrapper = do_CreateInstance(NS_VARIANT_CONTRACTID);                       \
    wrapper->SetAsAString(NS_ConvertUTF8toUTF16(nsDependentCString(*str)));   \
    array->AppendElement(wrapper, PR_FALSE);                                  \
    str++;                                                                    \
  }                                                                           \
                                                                              \
  callback->On##_cmd_##Result(array);                                         \
  NS_IF_RELEASE(callback);                                                    \
}

#define CS_TELEPATHY_REMOVE_OBSERVER(_class_,_function_,_observer_,_array_)   \
NS_IMETHODIMP _class_::_function_(_observer_ *observer)                       \
{                                                                             \
  if (!_array_)                                                               \
    return NS_ERROR_NOT_INITIALIZED;                                          \
                                                                              \
  PRUint32 index;                                                             \
  nsresult rv = _array_->IndexOf(0, observer, &index);                        \
  if(NS_FAILED(rv))                                                           \
    return rv;                                                                \
                                                                              \
  return _array_->RemoveElementAt(index);                                     \
}

#endif
