var gPrefInt = null;
var gAvailDirectories = null;
var gCurrentDirectoryServer = null;
var gCurrentDirectoryServerId = null;
var gRefresh = false;
var gNewServer = null;
var gNewServerString = null;
var gUpdate = false;
var gDeletedDirectories = new Array();
var gLDAPPrefsService;

function initLDAPPrefsService()
{
  if (gLDAPPrefsService)
    return;

  const LDAP_PREF_CONTRACT="@mozilla.org/ldapprefs-service;1";
  if (LDAP_PREF_CONTRACT in Components.classes)
  {
    gLDAPPrefsService = Components.classes[LDAP_PREF_CONTRACT].getService(Components.interfaces.nsILDAPPrefsService);
  }
}

function onEditDirectories()
{
  window.openDialog("chrome://messenger/content/addressbook/pref-editdirectories.xul",
                    "editDirectories", "chrome,modal=yes,resizable=no", null);
  if (gRefresh)
  {
    var popup = document.getElementById("directoriesListPopup"); 
    if (popup) 
    { 
       while (popup.hasChildNodes())
         popup.removeChild(popup.lastChild);
    } 
    gAvailDirectories = null;
    LoadDirectories(popup);
    gRefresh = false;
  }
}

function enableAutocomplete()
{
  var autocompleteLDAP = document.getElementById("autocompleteLDAP");  
  var directoriesList =  document.getElementById("directoriesList"); 
  var directoriesListPopup = document.getElementById("directoriesListPopup");
  var editButton = document.getElementById("editButton");
//  var autocompleteSkipDirectory = document.getElementById("autocompleteSkipDirectory");

  if (autocompleteLDAP.checked) {
    // If the default directory preference is locked 
    // disable the list popup
    if (gPrefInt.prefIsLocked("ldap_2.autoComplete.directoryServer")) {
      directoriesList.setAttribute("disabled", true);
      directoriesListPopup.setAttribute("disabled", true);
    }
    else {
      directoriesList.removeAttribute("disabled");
      directoriesListPopup.removeAttribute("disabled");
    } 
    editButton.removeAttribute("disabled");
//    autocompleteSkipDirectory.removeAttribute("disabled");
  }
  else {
    directoriesList.setAttribute("disabled", true);
    directoriesListPopup.setAttribute("disabled", true);
    editButton.setAttribute("disabled", true);
//    autocompleteSkipDirectory.setAttribute("disabled", true);
  }
  // if we do not have any directories disable the dropdown list box
  if (!gAvailDirectories || (gAvailDirectories.length < 1))
    directoriesList.setAttribute("disabled", true);
  LoadDirectories(directoriesListPopup);
}

function setupDirectoriesList()
{
  var override = document.getElementById("identity.overrideGlobalPref").getAttribute("value");
  var autocomplete = document.getElementById("ldapAutocomplete");
  // useGlobalFlag is set when user changes the selectedItem on the radio button and switches
  // to a different pane and switches back in Mail/news AccountSettings
  var useGlobalFlag = document.getElementById("overrideGlobalPref").getAttribute("value");
  // directoryServerFlag is set when user changes the server to None and switches
  // to a different pane and switches back in Mail/news AccountSettings
  var directoryServerFlag = document.getElementById("directoryServer").getAttribute("value");

  if(override == "true" && !useGlobalFlag)
    autocomplete.selectedItem = document.getElementById("directories");
  else
    autocomplete.selectedItem = document.getElementById("useGlobalPref");

  var directoriesList = document.getElementById("directoriesList");
  var directoryServer = 
        document.getElementById("identity.directoryServer").getAttribute('value');
  if (directoryServerFlag) {
    document.getElementById("identity.directoryServer").setAttribute("value", "");
    directoryServer = "";
  }
  directoriesList.value = directoryServer;
}

function createDirectoriesList()
{
  var directoriesListPopup = document.getElementById("directoriesListPopup");

  if (directoriesListPopup) {
    LoadDirectories(directoriesListPopup);
  }
}

function LoadDirectories(popup)
{
  var prefCount = {value:0};
  var description = "";
  var item;
  var j=0;
  var arrayOfDirectories;
  var position;
  var dirType;
  if (!gPrefInt) { 
    try {
      gPrefInt = Components.classes["@mozilla.org/preferences-service;1"]
                           .getService(Components.interfaces.nsIPrefBranch);
    }
    catch (ex) {
      gPrefInt = null;
    }
  }
  if (!gAvailDirectories) {
    try {
      initLDAPPrefsService();
      if (gLDAPPrefsService)
        arrayOfDirectories = gLDAPPrefsService.getServerList(gPrefInt, prefCount);
    }
    catch (ex) {
    }
  if (arrayOfDirectories) {
    gAvailDirectories = new Array();
    for (var i = 0; i < prefCount.value; i++)
    {
      if ((arrayOfDirectories[i] != "ldap_2.servers.pab") && 
        (arrayOfDirectories[i] != "ldap_2.servers.history")) {
        try{
          position = gPrefInt.getIntPref(arrayOfDirectories[i]+".position");
        }
        catch(ex){
          position = 1;
        }
        try{
          dirType = gPrefInt.getIntPref(arrayOfDirectories[i]+".dirType");
        }
        catch(ex){
          dirType = 1;
        }
        if ((position != 0) && (dirType == 1)) {
          try{
            description = gPrefInt.getComplexValue(arrayOfDirectories[i]+".description",
                                                   Components.interfaces.nsISupportsString).data;
          }
          catch(ex){
            description="";
          }
          if (description != "") {
            if (popup) {
              item=document.createElement("menuitem");
              item.setAttribute("label", description);
              item.setAttribute("value", arrayOfDirectories[i]);
              popup.appendChild(item);
            }
            gAvailDirectories[j++] = {value:arrayOfDirectories[i], label:description};
          }
        }
      }
    }
    if (popup)
    {
      // we are in mail/news Account settings
      item = document.createElement("menuitem");
      var addressBookBundle = document.getElementById("bundle_addressBook");
      var directoryName = addressBookBundle.getString("directoriesListItemNone");
      item.setAttribute("label", directoryName);
      item.setAttribute("value", "");
      popup.appendChild(item);

      // Now check what we are displaying is valid.
      var directoriesList = document.getElementById("directoriesList");
      var value = directoriesList.value;
      directoriesList.selectedItem = null;
      directoriesList.value = value;
      if (!directoriesList.selectedItem) {
        directoriesList.value = "";
        // If we have no other directories, also disable the popup.
        if (gAvailDirectories.length == 0)
          directoriesList.disabled = true;
      }
      // Only enable autocomplete if the pref isn't locked.
      else if (!gPrefInt.prefIsLocked("ldap_2.autoComplete.directoryServer"))
        directoriesList.disabled = false;
    }
  }
  }
}

function onInitEditDirectories()
{
  var listbox = document.getElementById("directoriesList");
  LoadDirectoriesList(listbox);
  // If the pref is locked disable the "Add" button
  if (gPrefInt.prefIsLocked("ldap_2.disable_button_add"))
    document.getElementById("addButton").setAttribute('disabled', true);
}

function LoadDirectoriesList(listbox)
{
  LoadDirectories();
  if (listbox && gAvailDirectories)
  {
    for (var i=0; i<gAvailDirectories.length; i++)
    {
      var item = document.createElement('listitem');

      item.setAttribute('label', gAvailDirectories[i].label);
      item.setAttribute('string', gAvailDirectories[i].value);

      listbox.appendChild(item);
    }
  }
}

function selectDirectory()
{
  var directoriesList = document.getElementById("directoriesList");
  if(directoriesList && directoriesList.selectedItems 
     && directoriesList.selectedItems.length)
  {
    gCurrentDirectoryServer = 
      directoriesList.selectedItems[0].getAttribute('label');
    gCurrentDirectoryServerId = 
     directoriesList.selectedItems[0].getAttribute('string');
  }
  else
  {
    gCurrentDirectoryServer = null;
    gCurrentDirectoryServerId = null;
  }

  var editButton = document.getElementById("editButton");
  var removeButton = document.getElementById("removeButton");
  if(gCurrentDirectoryServer && gCurrentDirectoryServerId) {
    editButton.removeAttribute("disabled");
    // If the disable delete button pref for the selected directory is set
    // disable the delete button for that directory.
    var disable = false;
	try {
	  disable = gPrefInt.getBoolPref(gCurrentDirectoryServerId + ".disable_delete");
	}
	catch(ex){
	  // if this preference is not set its ok.
	}
	if (disable)
      removeButton.setAttribute("disabled", true);
    else
      removeButton.removeAttribute("disabled");
  }
  else {
    editButton.setAttribute("disabled", true);
    removeButton.setAttribute("disabled", true);
  }
}

function clickDirectory(event)
{
  // We only care about left and double click events.
  if (event.button != 0 || event.detail != 2)
    return;

  editDirectory();
}

function newDirectory()
{
  window.openDialog("chrome://messenger/content/addressbook/pref-directory-add.xul",
                    "addDirectory", "chrome,modal=yes,resizable=no,centerscreen");
  if(gUpdate && gNewServer && gNewServerString) {
    var listbox = document.getElementById("directoriesList");
    var item = document.createElement('listitem');

    item.setAttribute('label', gNewServer);
    item.setAttribute('string', gNewServerString);

    listbox.appendChild(item);
    gNewServer = null;
    gNewServerString = null;
    window.opener.gRefresh = true;
  }
}

function editDirectory()
{
  if(gCurrentDirectoryServer && gCurrentDirectoryServerId) {
    var RDF = Components.classes["@mozilla.org/rdf/rdf-service;1"]
                      .getService(Components.interfaces.nsIRDFService);

    // the RDF resource URI for LDAPDirectory will be moz-abldapdirectory://<prefName>
    var selectedABURI = "moz-abldapdirectory://" + gCurrentDirectoryServerId;
    var selectedABDirectory = RDF.GetResource(selectedABURI)
                                 .QueryInterface(Components.interfaces.nsIAbDirectory);
    window.openDialog("chrome://messenger/content/addressbook/pref-directory-add.xul",
                      "editDirectory",
                      "chrome,modal=yes,resizable=no,centerscreen",
                      { selectedDirectory: selectedABDirectory });
  }
  if(gUpdate) 
  {
    // directory server properties have changed. So, update the  
    // LDAP Directory Servers dialog.  
    var directoriesList = document.getElementById("directoriesList"); 
    var selectedNode = directoriesList.selectedItems[0]; 
    selectedNode.setAttribute('label', gNewServer); 
    selectedNode.setAttribute('string', gNewServerString);
    
    // window.opener is either global pref window or 
    // mail/news account settings window.
    // set window.opener.gRefresh to true such that the 
    // dropdown list box gets updated 
    window.opener.gRefresh = true; 
  } 
}

function removeDirectory()
{
  var directoriesList = document.getElementById("directoriesList");
  var selectedNode = directoriesList.selectedItems[0];
    
  var nextNode = selectedNode.nextSibling;
  if (!nextNode)
    if (selectedNode.previousSibling)
      nextNode = selectedNode.previousSibling;

  if(gCurrentDirectoryServer && gCurrentDirectoryServerId) {
    var len= gDeletedDirectories.length;
    gDeletedDirectories[len] = gCurrentDirectoryServerId;
  }
  directoriesList.removeChild(selectedNode);
  if (nextNode)
    directoriesList.selectItem(nextNode)
}

//  remove all the directories that are selected for deletion from preferences
//  check if the deleted directory is selected for autocompletion in global
//  or identity prefs. If so change the pref to ""
function onAccept()
{
  var len = gDeletedDirectories.length;
  if (len) {
    try {
      var directoryServer = gPrefInt.getCharPref("ldap_2.autoComplete.directoryServer");
    }
    catch(ex)  {
      directoryServer = null;
    }
    var am = Components.classes["@mozilla.org/messenger/account-manager;1"]
                 .getService(Components.interfaces.nsIMsgAccountManager);
    if (am) {
      var addressbook;
      try {
        addressbook = Components.classes["@mozilla.org/abmanager;1"]
                                .getService(Components.interfaces.nsIAbManager);
      }
      catch(ex){
        dump("Failed to get addressbook " + ex + "\n");
      }
 
      var allIdentities = am.allIdentities;
      var identitiesCount = allIdentities.Count();
      var identityServer = new Array();
      var currentIdentity = null;
      var j;
      for (j=0; j< identitiesCount; j++) {
        currentIdentity = allIdentities.QueryElementAt(j, Components.interfaces.nsIMsgIdentity);
        identityServer[j] = {server:currentIdentity.directoryServer, deleted:false};
      }
      var deletedGlobal = false;
      for (var i=0; i< len; i++){
        if (!deletedGlobal && directoryServer && (gDeletedDirectories[i] == directoryServer)) {
          gPrefInt.setCharPref("ldap_2.autoComplete.directoryServer", "");
          deletedGlobal = true;
        }
        for (j=0; j<identitiesCount; j++){
          if (identityServer[j].server && !identityServer[j].deleted && (gDeletedDirectories[i] == identityServer[j].server)) {
            identityServer[j].server = "";
            identityServer[j].deleted = true;
          }
        }
        try {
          // The for LDAPDirectory will be moz-abldapdirectory://<prefName>
          addressbook.deleteAddressBook("moz-abldapdirectory://" +
                                        gDeletedDirectories[i]);
        }
        catch(ex){
          dump("Failed to delete the addressbook " + ex + "\n");
        }
      }
      var svc = Components.classes["@mozilla.org/preferences-service;1"]
                        .getService(Components.interfaces.nsIPrefService);
      svc.savePrefFile(null);
    }
  }
  window.opener.gRefresh = true;
  return true;
}

function doHelpButton()
{
  openHelp("mail-ldap-properties");
}
