/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.ashwood.graph;

import java.util.Iterator;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.apache.cayenne.ashwood.graph.ArcIterator;
import org.apache.cayenne.ashwood.graph.DigraphIteration;
import org.apache.cayenne.ashwood.graph.EmptyIterator;
import org.apache.cayenne.ashwood.graph.FilterArcIterator;

public class FilterIteration<E, V>
implements DigraphIteration<E, V> {
    private DigraphIteration<E, V> digraph;
    private Predicate<E> acceptVertex;
    private Predicate<V> acceptArc;

    public FilterIteration(DigraphIteration<E, V> digraph, Predicate<E> acceptVertex, Predicate<V> acceptArc) {
        this.digraph = digraph;
        this.acceptVertex = acceptVertex;
        this.acceptArc = acceptArc;
    }

    @Override
    public Iterator<E> vertexIterator() {
        Iterable iterable = () -> this.digraph.vertexIterator();
        return StreamSupport.stream(iterable.spliterator(), false).filter(this.acceptVertex).iterator();
    }

    @Override
    public ArcIterator<E, V> arcIterator() {
        return new FilterArcIterator<E, V>(this.digraph.arcIterator(), this.acceptVertex, this.acceptVertex, this.acceptArc);
    }

    @Override
    public ArcIterator<E, V> outgoingIterator(E vertex) {
        if (!this.acceptVertex.test(vertex)) {
            return EmptyIterator.instance();
        }
        return new FilterArcIterator<Object, V>(this.digraph.outgoingIterator(vertex), v -> true, this.acceptVertex, this.acceptArc);
    }

    @Override
    public ArcIterator<E, V> incomingIterator(E vertex) {
        if (!this.acceptVertex.test(vertex)) {
            return EmptyIterator.instance();
        }
        return new FilterArcIterator<Object, V>(this.digraph.incomingIterator(vertex), this.acceptVertex, v -> true, this.acceptArc);
    }
}

