/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SearchQueryDimFilter;
import org.apache.druid.query.search.ContainsSearchQuerySpec;
import org.apache.druid.query.search.SearchQuerySpec;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DirectOperatorConversion;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public class ContainsOperatorConversion
extends DirectOperatorConversion {
    private final boolean caseSensitive;

    private ContainsOperatorConversion(SqlFunction sqlFunction, boolean caseSensitive) {
        super((SqlOperator)sqlFunction, StringUtils.toLowerCase((String)sqlFunction.getName()));
        this.caseSensitive = caseSensitive;
    }

    public static SqlOperatorConversion caseSensitive() {
        SqlFunction sqlFunction = ContainsOperatorConversion.createSqlFunction("contains_string");
        return new ContainsOperatorConversion(sqlFunction, true);
    }

    public static SqlOperatorConversion caseInsensitive() {
        SqlFunction sqlFunction = ContainsOperatorConversion.createSqlFunction("icontains_string");
        return new ContainsOperatorConversion(sqlFunction, false);
    }

    private static SqlFunction createSqlFunction(String functionName) {
        return OperatorConversions.operatorBuilder(StringUtils.toUpperCase((String)functionName)).operandTypes(SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER).requiredOperandCount(2).literalOperands(1).returnTypeNullable(SqlTypeName.BOOLEAN).functionCategory(SqlFunctionCategory.STRING).build();
    }

    @Override
    @Nullable
    public DimFilter toDruidFilter(PlannerContext plannerContext, RowSignature rowSignature, @Nullable VirtualColumnRegistry virtualColumnRegistry, RexNode rexNode) {
        List operands = ((RexCall)rexNode).getOperands();
        DruidExpression druidExpression = Expressions.toDruidExpression(plannerContext, rowSignature, (RexNode)operands.get(0));
        if (druidExpression == null) {
            return null;
        }
        String search = RexLiteral.stringValue((RexNode)((RexNode)operands.get(1)));
        ContainsSearchQuerySpec spec = new ContainsSearchQuerySpec(search, this.caseSensitive);
        if (druidExpression.isSimpleExtraction()) {
            return new SearchQueryDimFilter(druidExpression.getSimpleExtraction().getColumn(), (SearchQuerySpec)spec, druidExpression.getSimpleExtraction().getExtractionFn(), null);
        }
        if (virtualColumnRegistry != null) {
            String v = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(druidExpression, ((RexNode)operands.get(0)).getType());
            return new SearchQueryDimFilter(v, (SearchQuerySpec)spec, null, null);
        }
        return null;
    }
}

