/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.transport;

import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.AttributeKey;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.function.Supplier;
import reactor.netty.ChannelPipelineConfigurer;
import reactor.netty.ConnectionObserver;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.netty.resources.LoopResources;
import reactor.netty.transport.TransportConfig;
import reactor.netty.transport.logging.AdvancedByteBufFormat;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.Metrics;
import reactor.util.annotation.Nullable;

public abstract class Transport<T extends Transport<T, C>, C extends TransportConfig> {
    static final Logger log = Loggers.getLogger(Transport.class);

    public <A> T attr(AttributeKey<A> key, @Nullable A value) {
        Objects.requireNonNull(key, "key");
        T dup = this.duplicate();
        ((TransportConfig)((Transport)dup).configuration()).attrs = TransportConfig.updateMap(((TransportConfig)this.configuration()).attrs, key, value);
        return dup;
    }

    public T bindAddress(Supplier<? extends SocketAddress> bindAddressSupplier) {
        Objects.requireNonNull(bindAddressSupplier, "bindAddressSupplier");
        T dup = this.duplicate();
        ((TransportConfig)((Transport)dup).configuration()).bindAddress = bindAddressSupplier;
        return dup;
    }

    public T channelGroup(ChannelGroup channelGroup) {
        Objects.requireNonNull(channelGroup, "channelGroup");
        T dup = this.duplicate();
        ((TransportConfig)((Transport)dup).configuration()).channelGroup = channelGroup;
        return dup;
    }

    public abstract C configuration();

    public T doOnChannelInit(ChannelPipelineConfigurer doOnChannelInit) {
        Objects.requireNonNull(doOnChannelInit, "doOnChannelInit");
        T dup = this.duplicate();
        ChannelPipelineConfigurer current = ((TransportConfig)this.configuration()).doOnChannelInit;
        ((TransportConfig)((Transport)dup).configuration()).doOnChannelInit = current == null ? doOnChannelInit : current.then(doOnChannelInit);
        return dup;
    }

    protected T metrics(boolean enable) {
        if (enable) {
            if (!Metrics.isInstrumentationAvailable()) {
                throw new UnsupportedOperationException("To enable metrics, you must add the dependency `io.micrometer:micrometer-core` to the class path first");
            }
            T dup = this.duplicate();
            ((TransportConfig)((Transport)dup).configuration()).metricsRecorder(() -> ((TransportConfig)this.configuration()).defaultMetricsRecorder());
            return dup;
        }
        if (((TransportConfig)this.configuration()).metricsRecorder != null) {
            T dup = this.duplicate();
            ((TransportConfig)((Transport)dup).configuration()).metricsRecorder(null);
            return dup;
        }
        Transport dup = this;
        return (T)dup;
    }

    public T metrics(boolean enable, Supplier<? extends ChannelMetricsRecorder> recorder) {
        if (enable) {
            T dup = this.duplicate();
            ((TransportConfig)((Transport)dup).configuration()).metricsRecorder(recorder);
            return dup;
        }
        if (((TransportConfig)this.configuration()).metricsRecorder != null) {
            T dup = this.duplicate();
            ((TransportConfig)((Transport)dup).configuration()).metricsRecorder(null);
            return dup;
        }
        Transport dup = this;
        return (T)dup;
    }

    public T observe(ConnectionObserver observer) {
        Objects.requireNonNull(observer, "observer");
        T dup = this.duplicate();
        ConnectionObserver current = ((TransportConfig)this.configuration()).observer;
        ((TransportConfig)((Transport)dup).configuration()).observer = current == null ? observer : current.then(observer);
        return dup;
    }

    public <O> T option(ChannelOption<O> key, @Nullable O value) {
        Objects.requireNonNull(key, "key");
        if (ChannelOption.AUTO_READ == key) {
            if (value instanceof Boolean && Boolean.TRUE.equals(value)) {
                log.error("ChannelOption.AUTO_READ is configured to be [false], it cannot be set to [true]");
            }
            Transport dup = this;
            return (T)dup;
        }
        T dup = this.duplicate();
        ((TransportConfig)((Transport)dup).configuration()).options = TransportConfig.updateMap(((TransportConfig)this.configuration()).options, key, value);
        return dup;
    }

    public T runOn(EventLoopGroup eventLoopGroup) {
        return this.runOn(new EventLoopGroupLoopResources(eventLoopGroup));
    }

    public T runOn(LoopResources channelResources) {
        Objects.requireNonNull(channelResources, "channelResources");
        return this.runOn(channelResources, LoopResources.DEFAULT_NATIVE);
    }

    public T runOn(LoopResources loopResources, boolean preferNative) {
        Objects.requireNonNull(loopResources, "loopResources");
        T dup = this.duplicate();
        C c = ((Transport)dup).configuration();
        ((TransportConfig)c).loopResources = loopResources;
        ((TransportConfig)c).preferNative = preferNative;
        return dup;
    }

    public T wiretap(boolean enable) {
        if (enable) {
            T dup = this.duplicate();
            ((TransportConfig)((Transport)dup).configuration()).loggingHandler = ((TransportConfig)this.configuration()).defaultLoggingHandler();
            return dup;
        }
        if (((TransportConfig)this.configuration()).loggingHandler != null) {
            T dup = this.duplicate();
            ((TransportConfig)((Transport)dup).configuration()).loggingHandler = null;
            return dup;
        }
        Transport dup = this;
        return (T)dup;
    }

    public T wiretap(String category) {
        Objects.requireNonNull(category, "category");
        return this.wiretap(category, LogLevel.DEBUG);
    }

    public T wiretap(String category, LogLevel level) {
        Objects.requireNonNull(category, "category");
        Objects.requireNonNull(level, "level");
        return this.wiretap(category, level, AdvancedByteBufFormat.HEX_DUMP);
    }

    public final T wiretap(String category, LogLevel level, AdvancedByteBufFormat format) {
        Objects.requireNonNull(category, "category");
        Objects.requireNonNull(level, "level");
        Objects.requireNonNull(format, "format");
        return this.wiretap(category, level, format, Charset.defaultCharset());
    }

    public final T wiretap(String category, LogLevel level, AdvancedByteBufFormat format, Charset charset) {
        Objects.requireNonNull(category, "category");
        Objects.requireNonNull(level, "level");
        Objects.requireNonNull(format, "format");
        Objects.requireNonNull(charset, "charset");
        LoggingHandler loggingHandler = format.toLoggingHandler(category, level, charset);
        if (loggingHandler.equals(((TransportConfig)this.configuration()).loggingHandler)) {
            Transport dup = this;
            return (T)dup;
        }
        T dup = this.duplicate();
        ((TransportConfig)((Transport)dup).configuration()).loggingHandler = loggingHandler;
        return dup;
    }

    protected abstract T duplicate();

    static final class EventLoopGroupLoopResources
    implements LoopResources {
        final EventLoopGroup eventLoopGroup;

        EventLoopGroupLoopResources(EventLoopGroup eventLoopGroup) {
            Objects.requireNonNull(eventLoopGroup, "eventLoopGroup");
            this.eventLoopGroup = eventLoopGroup;
        }

        @Override
        public EventLoopGroup onServer(boolean useNative) {
            return this.eventLoopGroup;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventLoopGroupLoopResources that = (EventLoopGroupLoopResources)o;
            return Objects.equals(this.eventLoopGroup, that.eventLoopGroup);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + Objects.hashCode(this.eventLoopGroup);
            return result;
        }
    }
}

