/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.server.security.AuthenticationUtils;
import org.eclipse.jetty.ee8.servlet.ServletContextHandler;
import org.eclipse.jetty.rewrite.handler.RedirectPatternRule;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.util.resource.ResourceFactory;

class WebConsoleJettyServerInitializer {
    private static final String WEB_CONSOLE_ROOT_DOCUMENT = "unified-console.html";
    private static final String WEB_CONSOLE_ROOT = StringUtils.format((String)"/%s", (Object[])new Object[]{"unified-console.html"});
    private static final List<String> UNSECURED_PATHS_FOR_UI = ImmutableList.of((Object)"/", (Object)"/favicon.png", (Object)"/assets/*", (Object)"/public/*", (Object)"/console-config.js");
    private static final List<String> UNAUTHORIZED_PATHS_FOR_UI = ImmutableList.of((Object)WEB_CONSOLE_ROOT);

    WebConsoleJettyServerInitializer() {
    }

    static void intializeServerForWebConsoleRoot(ServletContextHandler root) {
        root.setInitParameter("org.eclipse.jetty.servlet.Default.redirectWelcome", "true");
        root.setWelcomeFiles(new String[]{WEB_CONSOLE_ROOT_DOCUMENT});
        root.setBaseResource(ResourceFactory.root().newClassLoaderResource("org/apache/druid/console", false));
        AuthenticationUtils.addNoopAuthenticationAndAuthorizationFilters((ServletContextHandler)root, UNSECURED_PATHS_FOR_UI);
        AuthenticationUtils.addNoopAuthorizationFilters((ServletContextHandler)root, UNAUTHORIZED_PATHS_FOR_UI);
    }

    static RewriteHandler createWebConsoleRewriteHandler() {
        RewriteHandler rewrite = new RewriteHandler();
        WebConsoleJettyServerInitializer.addRedirectToWebConsoleRoot(rewrite, "/index.html");
        WebConsoleJettyServerInitializer.addRedirectToWebConsoleRoot(rewrite, "/console.html");
        WebConsoleJettyServerInitializer.addRedirectToWebConsoleRoot(rewrite, "/old-console.html");
        return rewrite;
    }

    private static void addRedirectToWebConsoleRoot(RewriteHandler rewrite, String oldPath) {
        RedirectPatternRule redirect = new RedirectPatternRule();
        redirect.setPattern(oldPath);
        redirect.setLocation(WEB_CONSOLE_ROOT);
        rewrite.addRule((Rule)redirect);
    }
}

