/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import org.apache.druid.msq.guice.MSQDurableStorageModule;
import org.apache.druid.msq.indexing.error.BaseMSQFault;

@JsonTypeName(value="DurableStorageConfiguration")
public class DurableStorageConfigurationFault
extends BaseMSQFault {
    static final String CODE = "DurableStorageConfiguration";
    private final String errorMessage;

    @JsonCreator
    public DurableStorageConfigurationFault(@JsonProperty(value="message") String errorMessage) {
        super(CODE, "Durable storage mode can only be enabled when %s is set to true and the connector is configured correctly. Check the documentation on how to enable durable storage mode. If you want to still query without durable storage mode, set %s to false in the query context. Got error %s", MSQDurableStorageModule.MSQ_INTERMEDIATE_STORAGE_ENABLED, "durableShuffleStorage", errorMessage);
        this.errorMessage = errorMessage;
    }

    @JsonProperty
    public String getMessage() {
        return this.errorMessage;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DurableStorageConfigurationFault that = (DurableStorageConfigurationFault)o;
        return Objects.equals(this.errorMessage, that.errorMessage);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.errorMessage);
    }
}

