/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit.results;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.processor.OutputChannelFactory;
import org.apache.druid.frame.processor.OutputChannels;
import org.apache.druid.frame.processor.manager.ProcessorManagers;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.msq.counters.ChannelCounters;
import org.apache.druid.msq.counters.CounterNames;
import org.apache.druid.msq.counters.CounterTracker;
import org.apache.druid.msq.exec.ExtraInfoHolder;
import org.apache.druid.msq.exec.FrameContext;
import org.apache.druid.msq.exec.ResultsContext;
import org.apache.druid.msq.exec.std.ProcessorsAndChannels;
import org.apache.druid.msq.exec.std.StandardStageProcessor;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSliceReader;
import org.apache.druid.msq.input.stage.StageInputSlice;
import org.apache.druid.msq.kernel.NilExtraInfoHolder;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.querykit.results.ExportResultsFrameProcessor;
import org.apache.druid.sql.calcite.planner.ColumnMappings;
import org.apache.druid.sql.http.ResultFormat;
import org.apache.druid.storage.ExportStorageProvider;
import org.apache.druid.utils.CollectionUtils;

@JsonTypeName(value="exportResults")
public class ExportResultsStageProcessor
extends StandardStageProcessor<Object, Object, Object> {
    private final String queryId;
    private final ExportStorageProvider exportStorageProvider;
    private final ResultFormat exportFormat;
    private final ColumnMappings columnMappings;
    private final ResultsContext resultsContext;

    @JsonCreator
    public ExportResultsStageProcessor(@JsonProperty(value="queryId") String queryId, @JsonProperty(value="exportStorageProvider") ExportStorageProvider exportStorageProvider, @JsonProperty(value="exportFormat") ResultFormat exportFormat, @JsonProperty(value="columnMappings") @Nullable ColumnMappings columnMappings, @JsonProperty(value="resultsContext") @Nullable ResultsContext resultsContext) {
        this.queryId = queryId;
        this.exportStorageProvider = exportStorageProvider;
        this.exportFormat = exportFormat;
        this.columnMappings = columnMappings;
        this.resultsContext = resultsContext;
    }

    @JsonProperty(value="queryId")
    public String getQueryId() {
        return this.queryId;
    }

    @JsonProperty(value="exportFormat")
    public ResultFormat getExportFormat() {
        return this.exportFormat;
    }

    @JsonProperty(value="exportStorageProvider")
    public ExportStorageProvider getExportStorageProvider() {
        return this.exportStorageProvider;
    }

    @JsonProperty(value="columnMappings")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public ColumnMappings getColumnMappings() {
        return this.columnMappings;
    }

    @JsonProperty(value="resultsContext")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public ResultsContext getResultsContext() {
        return this.resultsContext;
    }

    @Override
    public boolean usesProcessingBuffers() {
        return false;
    }

    @Override
    public ProcessorsAndChannels<Object, Object> makeProcessors(StageDefinition stageDefinition, int workerNumber, List<InputSlice> inputSlices, InputSliceReader inputSliceReader, @Nullable Object extra, OutputChannelFactory outputChannelFactory, FrameContext frameContext, int maxOutstandingProcessors, CounterTracker counters, Consumer<Throwable> warningPublisher) {
        StageInputSlice slice = (StageInputSlice)CollectionUtils.getOnlyElement(inputSlices, x -> DruidException.defensive().build("Expected only a single input slice but found [%s]", new Object[]{inputSlices}));
        if (inputSliceReader.numReadableInputs(slice) == 0) {
            return new ProcessorsAndChannels<Object, Object>(ProcessorManagers.of((Sequence)Sequences.empty()).withAccumulation(new ArrayList(), (acc, file) -> acc), OutputChannels.none());
        }
        ChannelCounters channelCounter = counters.channel(CounterNames.outputChannel());
        Sequence readableInputs = Sequences.simple((Iterable)inputSliceReader.attach(0, slice, counters, warningPublisher));
        Sequence processors = readableInputs.map(readableInput -> new ExportResultsFrameProcessor(readableInput.getChannel(), this.exportFormat, readableInput.getChannelFrameReader(), this.exportStorageProvider.createStorageConnector(frameContext.tempDir()), frameContext.jsonMapper(), channelCounter, ExportResultsStageProcessor.getExportFilePath(this.queryId, workerNumber, readableInput.getStagePartition().getPartitionNumber(), this.exportFormat), this.columnMappings, this.resultsContext, readableInput.getStagePartition().getPartitionNumber()));
        return new ProcessorsAndChannels<Object, Object>(ProcessorManagers.of((Sequence)processors).withAccumulation(new ArrayList(), (acc, file) -> {
            ((ArrayList)acc).add((String)file);
            return acc;
        }), OutputChannels.none());
    }

    @Override
    @Nullable
    public TypeReference<Object> getResultTypeReference() {
        return new TypeReference<Object>(){};
    }

    @Override
    public Object mergeAccumulatedResult(Object accumulated, Object otherAccumulated) {
        if (!(accumulated instanceof List)) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.RUNTIME_FAILURE).build("Expected a list result from worker, received [%s] instead. This might be due to workers having an older version.", new Object[]{accumulated.getClass()});
        }
        if (!(otherAccumulated instanceof List)) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.RUNTIME_FAILURE).build("Expected a list result from worker, received [%s] instead. This might be due to workers having an older version.", new Object[]{otherAccumulated.getClass()});
        }
        ((List)accumulated).addAll((List)otherAccumulated);
        return accumulated;
    }

    @Override
    public ExtraInfoHolder makeExtraInfoHolder(@Nullable Object extra) {
        if (extra != null) {
            throw new ISE("Expected null 'extra'", new Object[0]);
        }
        return NilExtraInfoHolder.instance();
    }

    private static String getExportFilePath(String queryId, int workerNumber, int partitionNumber, ResultFormat exportFormat) {
        return StringUtils.format((String)"%s-worker%s-partition%s.%s", (Object[])new Object[]{queryId, workerNumber, partitionNumber, exportFormat.toString()});
    }
}

