/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1DownwardAPIVolumeFile;
import io.kubernetes.client.openapi.models.V1DownwardAPIVolumeFileBuilder;
import io.kubernetes.client.openapi.models.V1DownwardAPIVolumeFileFluentImpl;
import io.kubernetes.client.openapi.models.V1DownwardAPIVolumeSource;
import io.kubernetes.client.openapi.models.V1DownwardAPIVolumeSourceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1DownwardAPIVolumeSourceFluentImpl<A extends V1DownwardAPIVolumeSourceFluent<A>>
extends BaseFluent<A>
implements V1DownwardAPIVolumeSourceFluent<A> {
    private Integer defaultMode;
    private ArrayList<V1DownwardAPIVolumeFileBuilder> items;

    public V1DownwardAPIVolumeSourceFluentImpl() {
    }

    public V1DownwardAPIVolumeSourceFluentImpl(V1DownwardAPIVolumeSource instance) {
        if (instance != null) {
            this.withDefaultMode(instance.getDefaultMode());
            this.withItems(instance.getItems());
        }
    }

    @Override
    public Integer getDefaultMode() {
        return this.defaultMode;
    }

    @Override
    public A withDefaultMode(Integer defaultMode) {
        this.defaultMode = defaultMode;
        return (A)this;
    }

    @Override
    public Boolean hasDefaultMode() {
        return this.defaultMode != null;
    }

    @Override
    public A addToItems(int index, V1DownwardAPIVolumeFile item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        V1DownwardAPIVolumeFileBuilder builder = new V1DownwardAPIVolumeFileBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get("items").add(index, builder);
            this.items.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToItems(int index, V1DownwardAPIVolumeFile item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        V1DownwardAPIVolumeFileBuilder builder = new V1DownwardAPIVolumeFileBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get("items").set(index, builder);
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(V1DownwardAPIVolumeFile ... items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (V1DownwardAPIVolumeFile item : items) {
            V1DownwardAPIVolumeFileBuilder builder = new V1DownwardAPIVolumeFileBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<V1DownwardAPIVolumeFile> items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (V1DownwardAPIVolumeFile item : items) {
            V1DownwardAPIVolumeFileBuilder builder = new V1DownwardAPIVolumeFileBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(V1DownwardAPIVolumeFile ... items) {
        for (V1DownwardAPIVolumeFile item : items) {
            V1DownwardAPIVolumeFileBuilder builder = new V1DownwardAPIVolumeFileBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<V1DownwardAPIVolumeFile> items) {
        for (V1DownwardAPIVolumeFile item : items) {
            V1DownwardAPIVolumeFileBuilder builder = new V1DownwardAPIVolumeFileBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<V1DownwardAPIVolumeFileBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<V1DownwardAPIVolumeFileBuilder> each = this.items.iterator();
        Object visitables = this._visitables.get("items");
        while (each.hasNext()) {
            V1DownwardAPIVolumeFileBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1DownwardAPIVolumeFile> getItems() {
        return this.items != null ? V1DownwardAPIVolumeSourceFluentImpl.build(this.items) : null;
    }

    @Override
    public List<V1DownwardAPIVolumeFile> buildItems() {
        return this.items != null ? V1DownwardAPIVolumeSourceFluentImpl.build(this.items) : null;
    }

    @Override
    public V1DownwardAPIVolumeFile buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public V1DownwardAPIVolumeFile buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public V1DownwardAPIVolumeFile buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public V1DownwardAPIVolumeFile buildMatchingItem(Predicate<V1DownwardAPIVolumeFileBuilder> predicate) {
        for (V1DownwardAPIVolumeFileBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<V1DownwardAPIVolumeFileBuilder> predicate) {
        for (V1DownwardAPIVolumeFileBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<V1DownwardAPIVolumeFile> items) {
        if (this.items != null) {
            this._visitables.get("items").clear();
        }
        if (items != null) {
            this.items = new ArrayList();
            for (V1DownwardAPIVolumeFile item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(V1DownwardAPIVolumeFile ... items) {
        if (this.items != null) {
            this.items.clear();
            this._visitables.remove("items");
        }
        if (items != null) {
            for (V1DownwardAPIVolumeFile item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public V1DownwardAPIVolumeSourceFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public V1DownwardAPIVolumeSourceFluent.ItemsNested<A> addNewItemLike(V1DownwardAPIVolumeFile item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public V1DownwardAPIVolumeSourceFluent.ItemsNested<A> setNewItemLike(int index, V1DownwardAPIVolumeFile item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public V1DownwardAPIVolumeSourceFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public V1DownwardAPIVolumeSourceFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public V1DownwardAPIVolumeSourceFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public V1DownwardAPIVolumeSourceFluent.ItemsNested<A> editMatchingItem(Predicate<V1DownwardAPIVolumeFileBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1DownwardAPIVolumeSourceFluentImpl that = (V1DownwardAPIVolumeSourceFluentImpl)o;
        if (!Objects.equals(this.defaultMode, that.defaultMode)) {
            return false;
        }
        return Objects.equals(this.items, that.items);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.defaultMode, this.items, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.defaultMode != null) {
            sb.append("defaultMode:");
            sb.append(this.defaultMode + ",");
        }
        if (this.items != null) {
            sb.append("items:");
            sb.append(this.items);
        }
        sb.append("}");
        return sb.toString();
    }

    class ItemsNestedImpl<N>
    extends V1DownwardAPIVolumeFileFluentImpl<V1DownwardAPIVolumeSourceFluent.ItemsNested<N>>
    implements V1DownwardAPIVolumeSourceFluent.ItemsNested<N>,
    Nested<N> {
        V1DownwardAPIVolumeFileBuilder builder;
        int index;

        ItemsNestedImpl(int index, V1DownwardAPIVolumeFile item) {
            this.index = index;
            this.builder = new V1DownwardAPIVolumeFileBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new V1DownwardAPIVolumeFileBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1DownwardAPIVolumeSourceFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

