/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.cluster.overlord;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import org.apache.druid.indexing.overlord.supervisor.autoscaler.LagStats;
import org.apache.druid.indexing.seekablestream.supervisor.LagAggregator;
import org.apache.druid.java.util.common.logger.Logger;

public class FaultyLagAggregator
implements LagAggregator {
    private static final Logger log = new Logger(FaultyLagAggregator.class);
    private final int lagMultiplier;
    private final LagAggregator delegate = LagAggregator.DEFAULT;

    @JsonCreator
    public FaultyLagAggregator(@JsonProperty(value="lagMultiplier") int lagMultiplier) {
        this.lagMultiplier = lagMultiplier;
        log.info("Multiplying lags by factor[%d].", new Object[]{lagMultiplier});
    }

    @JsonProperty
    public int getLagMultiplier() {
        return this.lagMultiplier;
    }

    public <PartitionIdType> LagStats aggregate(Map<PartitionIdType, Long> partitionLags) {
        LagStats originalAggregate = this.delegate.aggregate(partitionLags);
        return new LagStats(originalAggregate.getMaxLag() * (long)this.getLagMultiplier(), originalAggregate.getTotalLag() * (long)this.getLagMultiplier(), originalAggregate.getAvgLag() * (long)this.getLagMultiplier());
    }
}

