/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.protobuf.Descriptors;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.avatica.SqlType;
import org.apache.calcite.avatica.proto.Common;
import org.apache.calcite.avatica.util.ByteString;
import org.joou.UByte;
import org.joou.UInteger;
import org.joou.ULong;
import org.joou.UShort;

public class ColumnMetaData {
    private static final Descriptors.FieldDescriptor CATALOG_NAME_DESCRIPTOR = Common.ColumnMetaData.getDescriptor().findFieldByNumber(15);
    private static final Descriptors.FieldDescriptor SCHEMA_NAME_DESCRIPTOR = Common.ColumnMetaData.getDescriptor().findFieldByNumber(11);
    private static final Descriptors.FieldDescriptor LABEL_DESCRIPTOR = Common.ColumnMetaData.getDescriptor().findFieldByNumber(9);
    private static final Descriptors.FieldDescriptor COLUMN_NAME_DESCRIPTOR = Common.ColumnMetaData.getDescriptor().findFieldByNumber(10);
    private static final Descriptors.FieldDescriptor TABLE_NAME_DESCRIPTOR = Common.ColumnMetaData.getDescriptor().findFieldByNumber(14);
    private static final Descriptors.FieldDescriptor COLUMN_CLASS_NAME_DESCRIPTOR = Common.ColumnMetaData.getDescriptor().findFieldByNumber(19);
    public final int ordinal;
    public final boolean autoIncrement;
    public final boolean caseSensitive;
    public final boolean searchable;
    public final boolean currency;
    public final int nullable;
    public final boolean signed;
    public final int displaySize;
    public final String label;
    public final String columnName;
    public final String schemaName;
    public final int precision;
    public final int scale;
    public final String tableName;
    public final String catalogName;
    public final boolean readOnly;
    public final boolean writable;
    public final boolean definitelyWritable;
    public final String columnClassName;
    public final AvaticaType type;

    @JsonCreator
    public ColumnMetaData(@JsonProperty(value="ordinal") int ordinal, @JsonProperty(value="autoIncrement") boolean autoIncrement, @JsonProperty(value="caseSensitive") boolean caseSensitive, @JsonProperty(value="searchable") boolean searchable, @JsonProperty(value="currency") boolean currency, @JsonProperty(value="nullable") int nullable, @JsonProperty(value="signed") boolean signed, @JsonProperty(value="displaySize") int displaySize, @JsonProperty(value="label") String label, @JsonProperty(value="columnName") String columnName, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="precision") int precision, @JsonProperty(value="scale") int scale, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="catalogName") String catalogName, @JsonProperty(value="type") AvaticaType type, @JsonProperty(value="readOnly") boolean readOnly, @JsonProperty(value="writable") boolean writable, @JsonProperty(value="definitelyWritable") boolean definitelyWritable, @JsonProperty(value="columnClassName") String columnClassName) {
        this.ordinal = ordinal;
        this.autoIncrement = autoIncrement;
        this.caseSensitive = caseSensitive;
        this.searchable = searchable;
        this.currency = currency;
        this.nullable = nullable;
        this.signed = signed;
        this.displaySize = displaySize;
        this.label = label;
        this.columnName = ColumnMetaData.first(columnName, label);
        this.schemaName = schemaName;
        this.precision = precision;
        this.scale = scale;
        this.tableName = tableName;
        this.catalogName = catalogName;
        this.type = type;
        this.readOnly = readOnly;
        this.writable = writable;
        this.definitelyWritable = definitelyWritable;
        this.columnClassName = columnClassName;
    }

    public Common.ColumnMetaData toProto() {
        Common.ColumnMetaData.Builder builder = Common.ColumnMetaData.newBuilder();
        builder.setOrdinal(this.ordinal).setAutoIncrement(this.autoIncrement).setCaseSensitive(this.caseSensitive).setSearchable(this.searchable).setCurrency(this.currency).setNullable(this.nullable).setSigned(this.signed).setDisplaySize(this.displaySize).setPrecision(this.precision).setScale(this.scale).setReadOnly(this.readOnly).setWritable(this.writable).setDefinitelyWritable(this.definitelyWritable);
        if (null != this.label) {
            builder.setLabel(this.label);
        }
        if (null != this.columnName) {
            builder.setColumnName(this.columnName);
        }
        if (null != this.schemaName) {
            builder.setSchemaName(this.schemaName);
        }
        if (null != this.tableName) {
            builder.setTableName(this.tableName);
        }
        if (null != this.catalogName) {
            builder.setCatalogName(this.catalogName);
        }
        if (null != this.type) {
            builder.setType(this.type.toProto());
        }
        if (null != this.columnClassName) {
            builder.setColumnClassName(this.columnClassName);
        }
        return builder.build();
    }

    public static ColumnMetaData fromProto(Common.ColumnMetaData proto) {
        AvaticaType nestedType = AvaticaType.fromProto(proto.getType());
        String catalogName = null;
        if (proto.hasField(CATALOG_NAME_DESCRIPTOR)) {
            catalogName = proto.getCatalogName();
        }
        String schemaName = null;
        if (proto.hasField(SCHEMA_NAME_DESCRIPTOR)) {
            schemaName = proto.getSchemaName();
        }
        String label = null;
        if (proto.hasField(LABEL_DESCRIPTOR)) {
            label = proto.getLabel();
        }
        String columnName = null;
        if (proto.hasField(COLUMN_NAME_DESCRIPTOR)) {
            columnName = proto.getColumnName();
        }
        String tableName = null;
        if (proto.hasField(TABLE_NAME_DESCRIPTOR)) {
            tableName = proto.getTableName();
        }
        String columnClassName = null;
        if (proto.hasField(COLUMN_CLASS_NAME_DESCRIPTOR)) {
            columnClassName = proto.getColumnClassName();
        }
        return new ColumnMetaData(proto.getOrdinal(), proto.getAutoIncrement(), proto.getCaseSensitive(), proto.getSearchable(), proto.getCurrency(), proto.getNullable(), proto.getSigned(), proto.getDisplaySize(), label, columnName, schemaName, proto.getPrecision(), proto.getScale(), tableName, catalogName, nestedType, proto.getReadOnly(), proto.getWritable(), proto.getDefinitelyWritable(), columnClassName);
    }

    public int hashCode() {
        return Objects.hash(this.autoIncrement, this.caseSensitive, this.catalogName, this.columnClassName, this.columnName, this.currency, this.definitelyWritable, this.displaySize, this.label, this.nullable, this.ordinal, this.precision, this.readOnly, this.scale, this.schemaName, this.searchable, this.signed, this.tableName, this.type, this.writable);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof ColumnMetaData && this.autoIncrement == ((ColumnMetaData)o).autoIncrement && this.caseSensitive == ((ColumnMetaData)o).caseSensitive && Objects.equals(this.catalogName, ((ColumnMetaData)o).catalogName) && Objects.equals(this.columnClassName, ((ColumnMetaData)o).columnClassName) && Objects.equals(this.columnName, ((ColumnMetaData)o).columnName) && this.currency == ((ColumnMetaData)o).currency && this.definitelyWritable == ((ColumnMetaData)o).definitelyWritable && this.displaySize == ((ColumnMetaData)o).displaySize && Objects.equals(this.label, ((ColumnMetaData)o).label) && this.nullable == ((ColumnMetaData)o).nullable && this.ordinal == ((ColumnMetaData)o).ordinal && this.precision == ((ColumnMetaData)o).precision && this.readOnly == ((ColumnMetaData)o).readOnly && this.scale == ((ColumnMetaData)o).scale && Objects.equals(this.schemaName, ((ColumnMetaData)o).schemaName) && this.searchable == ((ColumnMetaData)o).searchable && this.signed == ((ColumnMetaData)o).signed && Objects.equals(this.tableName, ((ColumnMetaData)o).tableName) && Objects.equals(this.type, ((ColumnMetaData)o).type) && this.writable == ((ColumnMetaData)o).writable;
    }

    private static <T> T first(T t0, T t1) {
        return t0 != null ? t0 : t1;
    }

    public static ScalarType scalar(int type, String typeName, Rep rep) {
        return new ScalarType(type, typeName, rep);
    }

    public static StructType struct(List<ColumnMetaData> columns) {
        return new StructType(columns);
    }

    public static ArrayType array(AvaticaType componentType, String typeName, Rep rep) {
        return new ArrayType(2003, typeName, rep, componentType);
    }

    public static ColumnMetaData dummy(AvaticaType type, boolean nullable) {
        return new ColumnMetaData(0, false, true, false, false, nullable ? 1 : 0, true, -1, null, null, null, -1, -1, null, null, type, true, false, false, type.columnClassName());
    }

    public ColumnMetaData setRep(Rep rep) {
        return new ColumnMetaData(this.ordinal, this.autoIncrement, this.caseSensitive, this.searchable, this.currency, this.nullable, this.signed, this.displaySize, this.label, this.columnName, this.schemaName, this.precision, this.scale, this.tableName, this.catalogName, this.type.setRep(rep), this.readOnly, this.writable, this.definitelyWritable, this.columnClassName);
    }

    public static class ArrayType
    extends AvaticaType {
        private AvaticaType component;

        @JsonCreator
        public ArrayType(@JsonProperty(value="type") int type, @JsonProperty(value="name") String typeName, @JsonProperty(value="rep") Rep representation, @JsonProperty(value="component") AvaticaType component) {
            super(type, typeName, representation);
            this.component = component;
        }

        public void updateComponentType(AvaticaType component) {
            this.component = Objects.requireNonNull(component);
        }

        public AvaticaType getComponent() {
            return this.component;
        }

        @Override
        public Common.AvaticaType toProto() {
            Common.AvaticaType.Builder builder = Common.AvaticaType.newBuilder(super.toProto());
            builder.setComponent(this.component.toProto());
            return builder.build();
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.id, this.name, this.rep, this.component});
        }

        @Override
        public boolean equals(Object o) {
            return o == this || o instanceof ArrayType && super.equals(o) && Objects.equals(this.component, ((ArrayType)o).component);
        }
    }

    public static class StructType
    extends AvaticaType {
        public final List<ColumnMetaData> columns;

        @JsonCreator
        public StructType(List<ColumnMetaData> columns) {
            super(2002, "STRUCT", Rep.OBJECT);
            this.columns = columns;
        }

        @Override
        public Common.AvaticaType toProto() {
            Common.AvaticaType.Builder builder = Common.AvaticaType.newBuilder(super.toProto());
            for (ColumnMetaData valueType : this.columns) {
                builder.addColumns(valueType.toProto());
            }
            return builder.build();
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.id, this.name, this.rep, this.columns});
        }

        @Override
        public boolean equals(Object o) {
            return o == this || o instanceof StructType && super.equals(o) && Objects.equals(this.columns, ((StructType)o).columns);
        }
    }

    public static class ScalarType
    extends AvaticaType {
        @JsonCreator
        public ScalarType(@JsonProperty(value="id") int id, @JsonProperty(value="name") String name, @JsonProperty(value="rep") Rep rep) {
            super(id, name, rep);
        }

        @Override
        public AvaticaType setRep(Rep rep) {
            return new ScalarType(this.id, this.name, rep);
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=ScalarType.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=ScalarType.class, name="scalar"), @JsonSubTypes.Type(value=StructType.class, name="struct"), @JsonSubTypes.Type(value=ArrayType.class, name="array")})
    public static class AvaticaType {
        public final int id;
        public final String name;
        public final Rep rep;

        public AvaticaType(int id, String name, Rep rep) {
            this.id = id;
            this.name = Objects.requireNonNull(name);
            this.rep = Objects.requireNonNull(rep);
        }

        public String columnClassName() {
            return SqlType.valueOf(this.id).boxedClass().getName();
        }

        public String getName() {
            return this.name;
        }

        public AvaticaType setRep(Rep rep) {
            throw new UnsupportedOperationException();
        }

        public Common.AvaticaType toProto() {
            Common.AvaticaType.Builder builder = Common.AvaticaType.newBuilder();
            builder.setName(this.name);
            builder.setId(this.id);
            builder.setRep(this.rep.toProto());
            return builder.build();
        }

        public static AvaticaType fromProto(Common.AvaticaType proto) {
            AvaticaType type;
            Common.Rep repProto = proto.getRep();
            Rep rep = Rep.valueOf(repProto.name());
            if (proto.hasComponent()) {
                AvaticaType nestedType = AvaticaType.fromProto(proto.getComponent());
                type = ColumnMetaData.array(nestedType, proto.getName(), rep);
            } else if (proto.getColumnsCount() > 0) {
                ArrayList<ColumnMetaData> columns = new ArrayList<ColumnMetaData>(proto.getColumnsCount());
                for (Common.ColumnMetaData protoColumn : proto.getColumnsList()) {
                    columns.add(ColumnMetaData.fromProto(protoColumn));
                }
                type = ColumnMetaData.struct(columns);
            } else {
                type = ColumnMetaData.scalar(proto.getId(), proto.getName(), rep);
            }
            return type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.id, this.name, this.rep});
        }

        public boolean equals(Object o) {
            return o == this || o instanceof AvaticaType && this.id == ((AvaticaType)o).id && Objects.equals(this.name, ((AvaticaType)o).name) && this.rep == ((AvaticaType)o).rep;
        }
    }

    public static enum Rep {
        PRIMITIVE_BOOLEAN(Boolean.TYPE, 16),
        PRIMITIVE_BYTE(Byte.TYPE, -6),
        PRIMITIVE_CHAR(Character.TYPE, 1),
        PRIMITIVE_SHORT(Short.TYPE, 5),
        PRIMITIVE_INT(Integer.TYPE, 4),
        PRIMITIVE_LONG(Long.TYPE, -5),
        PRIMITIVE_FLOAT(Float.TYPE, 6),
        PRIMITIVE_DOUBLE(Double.TYPE, 8),
        BOOLEAN(Boolean.class, 16),
        BYTE(Byte.class, -6),
        UBYTE(UByte.class, -6),
        CHARACTER(Character.class, 1),
        SHORT(Short.class, 5),
        USHORT(UShort.class, 5),
        INTEGER(Integer.class, 4),
        UINTEGER(UInteger.class, 4),
        LONG(Long.class, -5),
        ULONG(ULong.class, -5),
        FLOAT(Float.class, 6),
        DOUBLE(Double.class, 8),
        JAVA_SQL_TIME(Time.class, 92),
        JAVA_SQL_TIMESTAMP(Timestamp.class, 93),
        JAVA_SQL_DATE(Date.class, 91),
        JAVA_UTIL_DATE(java.util.Date.class, 91),
        BYTE_STRING(ByteString.class, -3),
        STRING(String.class, 12),
        NUMBER(BigDecimal.class, 2),
        ARRAY(Array.class, 2003),
        MULTISET(List.class, 2000),
        STRUCT(Struct.class, 2000),
        OBJECT(Object.class, 2000);

        public final Class clazz;
        public final int typeId;
        public static final Map<Class, Rep> VALUE_MAP;

        private Rep(Class clazz, int typeId) {
            this.clazz = clazz;
            this.typeId = typeId;
        }

        public static Rep of(Type clazz) {
            Rep rep = VALUE_MAP.get(clazz);
            return rep != null ? rep : OBJECT;
        }

        public Object jdbcGet(ResultSet resultSet, int i) throws SQLException {
            switch (this) {
                case PRIMITIVE_BOOLEAN: {
                    return resultSet.getBoolean(i);
                }
                case PRIMITIVE_BYTE: {
                    return resultSet.getByte(i);
                }
                case PRIMITIVE_SHORT: {
                    return resultSet.getShort(i);
                }
                case PRIMITIVE_INT: {
                    return resultSet.getInt(i);
                }
                case PRIMITIVE_LONG: {
                    return resultSet.getLong(i);
                }
                case PRIMITIVE_FLOAT: {
                    return Float.valueOf(resultSet.getFloat(i));
                }
                case PRIMITIVE_DOUBLE: {
                    return resultSet.getDouble(i);
                }
                case BOOLEAN: {
                    boolean aBoolean = resultSet.getBoolean(i);
                    return resultSet.wasNull() ? null : Boolean.valueOf(aBoolean);
                }
                case BYTE: {
                    byte aByte = resultSet.getByte(i);
                    return resultSet.wasNull() ? null : Byte.valueOf(aByte);
                }
                case SHORT: {
                    short aShort = resultSet.getShort(i);
                    return resultSet.wasNull() ? null : Short.valueOf(aShort);
                }
                case INTEGER: {
                    int anInt = resultSet.getInt(i);
                    return resultSet.wasNull() ? null : Integer.valueOf(anInt);
                }
                case LONG: {
                    long aLong = resultSet.getLong(i);
                    return resultSet.wasNull() ? null : Long.valueOf(aLong);
                }
                case FLOAT: {
                    float aFloat = resultSet.getFloat(i);
                    return resultSet.wasNull() ? null : Float.valueOf(aFloat);
                }
                case DOUBLE: {
                    double aDouble = resultSet.getDouble(i);
                    return resultSet.wasNull() ? null : Double.valueOf(aDouble);
                }
                case JAVA_SQL_DATE: {
                    return resultSet.getDate(i);
                }
                case JAVA_SQL_TIME: {
                    return resultSet.getTime(i);
                }
                case JAVA_SQL_TIMESTAMP: {
                    return resultSet.getTimestamp(i);
                }
                case ARRAY: {
                    return resultSet.getArray(i);
                }
                case STRUCT: {
                    return resultSet.getObject(i, Struct.class);
                }
            }
            return resultSet.getObject(i);
        }

        public Common.Rep toProto() {
            return Common.Rep.valueOf(this.name());
        }

        public static Rep fromProto(Common.Rep proto) {
            if (Common.Rep.UNRECOGNIZED == proto) {
                return null;
            }
            if (Common.Rep.BIG_DECIMAL == proto) {
                return NUMBER;
            }
            if (Common.Rep.NULL == proto) {
                return OBJECT;
            }
            return Rep.valueOf(proto.name());
        }

        public static Rep nonPrimitiveRepOf(SqlType type) {
            if (null == type) {
                throw new NullPointerException();
            }
            if (Boolean.TYPE == type.clazz) {
                return BOOLEAN;
            }
            if (Byte.TYPE == type.clazz) {
                return BYTE;
            }
            if (Character.TYPE == type.clazz) {
                return CHARACTER;
            }
            if (Short.TYPE == type.clazz) {
                return SHORT;
            }
            if (Integer.TYPE == type.clazz) {
                return INTEGER;
            }
            if (Long.TYPE == type.clazz) {
                return LONG;
            }
            if (Float.TYPE == type.clazz) {
                return FLOAT;
            }
            if (Double.TYPE == type.clazz) {
                return DOUBLE;
            }
            return Rep.of(type.clazz);
        }

        public static Rep serialRepOf(SqlType type) {
            if (null == type) {
                throw new NullPointerException();
            }
            if (Boolean.TYPE == type.internal) {
                return BOOLEAN;
            }
            if (Byte.TYPE == type.internal) {
                return BYTE;
            }
            if (Character.TYPE == type.internal) {
                return CHARACTER;
            }
            if (Short.TYPE == type.internal) {
                return SHORT;
            }
            if (Integer.TYPE == type.internal) {
                return INTEGER;
            }
            if (Long.TYPE == type.internal) {
                return LONG;
            }
            if (Float.TYPE == type.internal) {
                return FLOAT;
            }
            if (Double.TYPE == type.internal) {
                return DOUBLE;
            }
            return Rep.of(type.internal);
        }

        static {
            HashMap<Class<byte[]>, Rep> builder = new HashMap<Class<byte[]>, Rep>();
            for (Rep rep : Rep.values()) {
                builder.put(rep.clazz, rep);
            }
            builder.put(byte[].class, BYTE_STRING);
            VALUE_MAP = Collections.unmodifiableMap(builder);
        }
    }
}

