/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.rpc;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import org.apache.druid.rpc.ServiceLocation;
import org.apache.druid.rpc.ServiceLocations;
import org.apache.druid.rpc.ServiceLocator;

public class FixedServiceLocator
implements ServiceLocator {
    private final ServiceLocations locations;
    private volatile boolean closed = false;

    public FixedServiceLocator(ServiceLocations locations) {
        this.locations = (ServiceLocations)Preconditions.checkNotNull((Object)locations);
    }

    public FixedServiceLocator(ServiceLocation location) {
        this(ServiceLocations.forLocation(location));
    }

    @Override
    public ListenableFuture<ServiceLocations> locate() {
        if (this.closed) {
            return Futures.immediateFuture((Object)ServiceLocations.closed());
        }
        return Futures.immediateFuture((Object)this.locations);
    }

    @Override
    public void close() {
        this.closed = true;
    }
}

