/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.druid.java.util.common.IAE;

public class StringTuple
implements Comparable<StringTuple> {
    private final String[] values;

    public static StringTuple create(String ... values) {
        return new StringTuple(values);
    }

    public static String firstOrNull(StringTuple tuple) {
        return tuple == null || tuple.size() < 1 ? null : tuple.get(0);
    }

    @JsonCreator
    public StringTuple(String[] values) {
        Preconditions.checkNotNull((Object)values, (Object)"Array of values should not be null");
        this.values = values;
    }

    public String get(int index) {
        return this.values[index];
    }

    public int size() {
        return this.values.length;
    }

    @JsonValue
    public String[] toArray() {
        return this.values;
    }

    @Override
    public int compareTo(StringTuple that) {
        if (this == that) {
            return 0;
        }
        if (that == null) {
            return 1;
        }
        if (this.size() != that.size()) {
            throw new IAE("Cannot compare StringTuples of different sizes", new Object[0]);
        }
        if (this.size() == 0) {
            return 0;
        }
        for (int i = 0; i < this.size(); ++i) {
            int comparison = this.nullSafeCompare(this.get(i), that.get(i));
            if (comparison == 0) continue;
            return comparison;
        }
        return 0;
    }

    private int nullSafeCompare(String a, String b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringTuple that = (StringTuple)o;
        return Arrays.equals(this.values, that.values);
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public String toString() {
        return Arrays.toString(this.values);
    }
}

