/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.CastToTypeVectorProcessor;
import org.apache.druid.math.expr.vector.ExprEvalObjectVector;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;

public class CastToObjectVectorProcessor
extends CastToTypeVectorProcessor<Object[]> {
    private final ExpressionType outputType;
    private final ExpressionType delegateType;
    private final Object[] output;

    public CastToObjectVectorProcessor(ExprVectorProcessor<?> delegate, ExpressionType outputType) {
        super(delegate);
        this.delegateType = delegate.getOutputType();
        this.outputType = outputType;
        this.output = new Object[delegate.maxVectorSize()];
    }

    @Override
    public ExprEvalVector<Object[]> evalVector(Expr.VectorInputBinding bindings) {
        ExprEvalVector delegateOutput = this.delegate.evalVector(bindings);
        Object[] toCast = delegateOutput.getObjectVector();
        for (int i = 0; i < bindings.getCurrentVectorSize(); ++i) {
            ExprEval cast = ExprEval.ofType(this.delegateType, toCast[i]).castTo(this.outputType);
            this.output[i] = cast.value();
        }
        return new ExprEvalObjectVector(this.output, this.outputType);
    }

    @Override
    public ExpressionType getOutputType() {
        return this.outputType;
    }
}

