/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;

public class DoubleMaxAggregator
implements Aggregator {
    private final BaseDoubleColumnValueSelector selector;
    private double max;

    static double combineValues(Object lhs, Object rhs) {
        return Math.max(((Number)lhs).doubleValue(), ((Number)rhs).doubleValue());
    }

    public DoubleMaxAggregator(BaseDoubleColumnValueSelector selector) {
        this.selector = selector;
        this.max = Double.NEGATIVE_INFINITY;
    }

    @Override
    public void aggregate() {
        this.max = Math.max(this.max, this.selector.getDouble());
    }

    @Override
    public Object get() {
        return this.max;
    }

    @Override
    public float getFloat() {
        return (float)this.max;
    }

    @Override
    public long getLong() {
        return (long)this.max;
    }

    @Override
    public double getDouble() {
        return this.max;
    }

    @Override
    public void close() {
    }
}

