/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.segment.SegmentSchemaMapping;
import org.apache.druid.timeline.DataSegment;

public class DataSegmentsWithSchemas {
    private final Set<DataSegment> segments;
    @Nullable
    private final SegmentSchemaMapping segmentSchemaMapping;

    public DataSegmentsWithSchemas(int schemaVersion) {
        this.segments = new HashSet<DataSegment>();
        this.segmentSchemaMapping = new SegmentSchemaMapping(schemaVersion);
    }

    @JsonCreator
    public DataSegmentsWithSchemas(@JsonProperty(value="segments") Set<DataSegment> segments, @JsonProperty(value="segmentSchemaMapping") @Nullable SegmentSchemaMapping segmentSchemaMapping) {
        this.segments = segments;
        this.segmentSchemaMapping = segmentSchemaMapping;
    }

    @JsonProperty
    public Set<DataSegment> getSegments() {
        return this.segments;
    }

    @Nullable
    @JsonProperty
    public SegmentSchemaMapping getSegmentSchemaMapping() {
        return this.segmentSchemaMapping;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSegmentsWithSchemas that = (DataSegmentsWithSchemas)o;
        return Objects.equals(this.segments, that.segments) && Objects.equals(this.segmentSchemaMapping, that.segmentSchemaMapping);
    }

    public int hashCode() {
        return Objects.hash(this.segments, this.segmentSchemaMapping);
    }
}

