/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter.cnf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.druid.java.util.common.NonnullPair;
import org.apache.druid.query.filter.BooleanFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.filter.AndFilter;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.filter.NotFilter;
import org.apache.druid.segment.filter.OrFilter;
import org.apache.druid.segment.filter.cnf.CNFFilterExplosionException;

public class HiveCnfHelper {
    private static final int CNF_MAX_FILTER_THRESHOLD = 10000;

    public static Filter pushDownNot(Filter current) {
        ArrayList<Filter> children;
        if (current instanceof NotFilter) {
            Filter child = ((NotFilter)current).getBaseFilter();
            if (child instanceof NotFilter) {
                return HiveCnfHelper.pushDownNot(((NotFilter)child).getBaseFilter());
            }
            if (child instanceof AndFilter) {
                ArrayList<Filter> children2 = new ArrayList<Filter>();
                for (Filter grandChild : ((AndFilter)child).getFilters()) {
                    children2.add(HiveCnfHelper.pushDownNot(new NotFilter(grandChild)));
                }
                return Filters.or(children2);
            }
            if (child instanceof OrFilter) {
                ArrayList<Filter> children3 = new ArrayList<Filter>();
                for (Filter grandChild : ((OrFilter)child).getFilters()) {
                    children3.add(HiveCnfHelper.pushDownNot(new NotFilter(grandChild)));
                }
                return Filters.and(children3);
            }
        }
        if (current instanceof AndFilter) {
            children = new ArrayList<Filter>();
            for (Filter child : ((AndFilter)current).getFilters()) {
                children.add(HiveCnfHelper.pushDownNot(child));
            }
            return Filters.and(children);
        }
        if (current instanceof OrFilter) {
            children = new ArrayList();
            for (Filter child : ((OrFilter)current).getFilters()) {
                children.add(HiveCnfHelper.pushDownNot(child));
            }
            return Filters.or(children);
        }
        return current;
    }

    public static Filter convertToCnf(Filter current) throws CNFFilterExplosionException {
        return (Filter)HiveCnfHelper.convertToCnfWithLimit((Filter)current, (int)10000).lhs;
    }

    private static NonnullPair<Filter, Integer> convertToCnfWithLimit(Filter current, int maxCNFFilterLimit) throws CNFFilterExplosionException {
        if (current instanceof NotFilter) {
            NonnullPair<Filter, Integer> result = HiveCnfHelper.convertToCnfWithLimit(((NotFilter)current).getBaseFilter(), maxCNFFilterLimit);
            return new NonnullPair<Filter, Integer>(new NotFilter((Filter)result.lhs), (Integer)result.rhs);
        }
        if (current instanceof AndFilter) {
            ArrayList<Filter> children = new ArrayList<Filter>();
            for (Filter child : ((AndFilter)current).getFilters()) {
                NonnullPair<Filter, Integer> result = HiveCnfHelper.convertToCnfWithLimit(child, maxCNFFilterLimit);
                children.add((Filter)result.lhs);
                maxCNFFilterLimit = (Integer)result.rhs;
                if (maxCNFFilterLimit >= 0) continue;
                throw new CNFFilterExplosionException("Exceeded maximum allowed filters for CNF (conjunctive normal form) conversion", new Object[0]);
            }
            return new NonnullPair<Filter, Integer>(Filters.and(children), maxCNFFilterLimit);
        }
        if (current instanceof OrFilter) {
            ArrayList<Filter> nonAndList = new ArrayList<Filter>();
            ArrayList<Filter> andList = new ArrayList<Filter>();
            for (Filter child : ((OrFilter)current).getFilters()) {
                if (child instanceof AndFilter) {
                    andList.add(child);
                    continue;
                }
                if (child instanceof OrFilter) {
                    nonAndList.addAll(((OrFilter)child).getFilters());
                    continue;
                }
                nonAndList.add(child);
            }
            if (!andList.isEmpty()) {
                ArrayList<Filter> result = new ArrayList<Filter>();
                HiveCnfHelper.generateAllCombinations(result, andList, nonAndList, maxCNFFilterLimit);
                return new NonnullPair<Filter, Integer>(Filters.and(result), maxCNFFilterLimit - result.size());
            }
        }
        return new NonnullPair<Filter, Integer>(current, maxCNFFilterLimit);
    }

    public static Filter flatten(Filter root) {
        if (root instanceof BooleanFilter) {
            ArrayList<Filter> children = new ArrayList<Filter>(((BooleanFilter)root).getFilters());
            for (int i = 0; i < children.size(); ++i) {
                Filter child = HiveCnfHelper.flatten((Filter)children.get(i));
                if (child.getClass() == root.getClass() && !(child instanceof NotFilter)) {
                    boolean first = true;
                    ArrayList<Filter> grandKids = new ArrayList<Filter>(((BooleanFilter)child).getFilters());
                    for (Filter grandkid : grandKids) {
                        if (first) {
                            first = false;
                            children.set(i, grandkid);
                            continue;
                        }
                        children.add(++i, grandkid);
                    }
                    continue;
                }
                children.set(i, child);
            }
            if (children.size() == 1 && (root instanceof AndFilter || root instanceof OrFilter)) {
                return (Filter)children.get(0);
            }
            if (root instanceof AndFilter) {
                return new AndFilter(children);
            }
            if (root instanceof OrFilter) {
                return new OrFilter(children);
            }
        }
        return root;
    }

    private static void generateAllCombinations(List<Filter> result, List<Filter> andList, List<Filter> nonAndList, int maxAllowedFilters) throws CNFFilterExplosionException {
        ArrayList<Filter> children = new ArrayList<Filter>(((AndFilter)andList.get(0)).getFilters());
        if (result.isEmpty()) {
            for (Filter child : children) {
                ArrayList<Filter> a = new ArrayList<Filter>(nonAndList);
                a.add(child);
                result.add(HiveCnfHelper.idempotentOr(Filters.or(a)));
                if (result.size() <= maxAllowedFilters) continue;
                throw new CNFFilterExplosionException("Exceeded maximum allowed filters for CNF (conjunctive normal form) conversion", new Object[0]);
            }
        } else {
            ArrayList<Filter> work = new ArrayList<Filter>(result);
            result.clear();
            for (Filter child : children) {
                for (Filter or : work) {
                    ArrayList<Filter> a = new ArrayList<Filter>(((OrFilter)or).getFilters());
                    a.add(child);
                    result.add(HiveCnfHelper.idempotentOr(Filters.or(a)));
                    if (result.size() <= maxAllowedFilters) continue;
                    throw new CNFFilterExplosionException("Exceeded maximum allowed filters for CNF (conjunctive normal form) conversion", new Object[0]);
                }
            }
        }
        if (andList.size() > 1) {
            HiveCnfHelper.generateAllCombinations(result, andList.subList(1, andList.size()), nonAndList, maxAllowedFilters);
        }
    }

    private static OrFilter idempotentOr(Filter filter) {
        return filter instanceof OrFilter ? (OrFilter)filter : new OrFilter(Collections.singletonList(filter));
    }

    private HiveCnfHelper() {
    }
}

