/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.remote;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Enumeration;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.input.NullInputStream;
import org.apache.druid.data.input.impl.RetryingInputStream;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.IOE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.storage.StorageConnector;
import org.apache.druid.storage.remote.ChunkingStorageConnectorParameters;

public abstract class ChunkingStorageConnector<T>
implements StorageConnector {
    private static final long DOWNLOAD_MAX_CHUNK_SIZE_BYTES = 100000000L;
    private static final int FETCH_BUFFER_SIZE_BYTES = 8192;
    private final long chunkSizeBytes;

    public ChunkingStorageConnector() {
        this(100000000L);
    }

    public ChunkingStorageConnector(long chunkSizeBytes) {
        this.chunkSizeBytes = chunkSizeBytes;
    }

    @Override
    public InputStream read(String path) throws IOException {
        return this.buildInputStream(this.buildInputParams(path));
    }

    @Override
    public InputStream readRange(String path, long from, long size) {
        return this.buildInputStream(this.buildInputParams(path, from, size));
    }

    public abstract ChunkingStorageConnectorParameters<T> buildInputParams(String var1) throws IOException;

    public abstract ChunkingStorageConnectorParameters<T> buildInputParams(String var1, long var2, long var4);

    private InputStream buildInputStream(final ChunkingStorageConnectorParameters<T> params) {
        final AtomicLong currentReadStartPosition = new AtomicLong(params.getStart());
        final long readEnd = params.getEnd();
        final AtomicBoolean isSequenceStreamClosed = new AtomicBoolean(false);
        return new SequenceInputStream(new Enumeration<InputStream>(){
            boolean initStream = false;

            @Override
            public boolean hasMoreElements() {
                if (isSequenceStreamClosed.get()) {
                    return false;
                }
                return currentReadStartPosition.get() < readEnd;
            }

            @Override
            public InputStream nextElement() {
                if (!this.initStream) {
                    this.initStream = true;
                    return new NullInputStream();
                }
                final File outFile = new File(params.getTempDirSupplier().get().getAbsolutePath(), UUID.randomUUID().toString());
                final long currentReadEndPosition = Math.min(currentReadStartPosition.get() + ChunkingStorageConnector.this.chunkSizeBytes, readEnd);
                try {
                    if (!outFile.createNewFile()) {
                        throw new IOE(StringUtils.format("Could not create temporary file [%s] for copying [%s]", outFile.getAbsolutePath(), params.getCloudStoragePath()), new Object[0]);
                    }
                    FileUtils.copyLarge(() -> new RetryingInputStream(params.getObjectSupplier().getObject(currentReadStartPosition.get(), currentReadEndPosition), params.getObjectOpenFunction(), params.getRetryCondition(), params.getMaxRetry()), outFile, new byte[8192], (Predicate<Throwable>)Predicates.alwaysFalse(), 1, StringUtils.format("Retrying copying of [%s] to [%s]", params.getCloudStoragePath(), outFile.getAbsolutePath()));
                }
                catch (IOException e) {
                    throw new RE(e, StringUtils.format("Unable to copy [%s] to [%s]", params.getCloudStoragePath(), outFile), new Object[0]);
                }
                try {
                    final AtomicBoolean fileInputStreamClosed = new AtomicBoolean(false);
                    return new FileInputStream(outFile){

                        @Override
                        public void close() throws IOException {
                            if (fileInputStreamClosed.get()) {
                                return;
                            }
                            fileInputStreamClosed.set(true);
                            super.close();
                            currentReadStartPosition.set(currentReadEndPosition);
                            if (!outFile.delete()) {
                                throw new RE("Cannot delete temp file [%s]", outFile);
                            }
                        }
                    };
                }
                catch (FileNotFoundException e) {
                    throw new RE(e, StringUtils.format("Unable to find temp file [%s]", outFile), new Object[0]);
                }
            }
        }){

            @Override
            public void close() throws IOException {
                isSequenceStreamClosed.set(true);
                super.close();
            }
        };
    }

    public static interface GetObjectFromRangeFunction<T> {
        public T getObject(long var1, long var3);
    }
}

