/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.hash.Hashing;
import org.apache.druid.java.util.common.StringUtils;

public enum HashPartitionFunction {
    MURMUR3_32_ABS{

        @Override
        public int hash(byte[] serializedRow, int numBuckets) {
            return Math.abs(Hashing.murmur3_32().hashBytes(serializedRow).asInt() % numBuckets);
        }
    };


    public abstract int hash(byte[] var1, int var2);

    @JsonCreator
    public static HashPartitionFunction fromString(String type) {
        return HashPartitionFunction.valueOf(StringUtils.toUpperCase(type));
    }

    @JsonValue
    public String toString() {
        return StringUtils.toLowerCase(this.name());
    }
}

