/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.proj.Projection;

public class NellHProjection
extends Projection {
    private static final int NITER = 9;
    private static final double EPS = 1.0E-7;

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        out.x = 0.5 * lplam * (1.0 + Math.cos(lpphi));
        out.y = 2.0 * (lpphi - Math.tan(0.5 * lpphi));
        return out;
    }

    @Override
    public ProjCoordinate projectInverse(double xyx, double xyy, ProjCoordinate out) {
        int i;
        double p = 0.5 * xyy;
        for (i = 9; i > 0; --i) {
            double c = Math.cos(0.5 * xyy);
            double V = (xyy - Math.tan(xyy / 2.0) - p) / (1.0 - 0.5 / (c * c));
            out.y -= V;
            if (Math.abs(V) < 1.0E-7) break;
        }
        if (i == 0) {
            out.y = p < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
            out.x = 2.0 * xyx;
        } else {
            out.x = 2.0 * xyx / (1.0 + Math.cos(xyy));
        }
        return out;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Nell-Hammer";
    }
}

