/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import com.google.errorprone.annotations.ThreadSafe;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.trino.jdbc.$internal.client.Warning;
import io.trino.jdbc.TrinoSqlWarning;
import java.sql.SQLWarning;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@ThreadSafe
final class WarningsManager {
    @GuardedBy(value="this")
    private final Set<Warning.Code> warningsSeen = new HashSet<Warning.Code>();
    @GuardedBy(value="this")
    private SQLWarning firstWarning;
    @GuardedBy(value="this")
    private SQLWarning lastWarning;

    WarningsManager() {
    }

    private synchronized void addWarning(Warning warning) {
        Objects.requireNonNull(warning, "warning is null");
        if (this.lastWarning == null) {
            this.lastWarning = new TrinoSqlWarning(warning);
        } else {
            this.lastWarning.setNextWarning(new TrinoSqlWarning(warning));
        }
        if (this.firstWarning == null) {
            this.firstWarning = this.lastWarning;
        } else {
            this.lastWarning = this.lastWarning.getNextWarning();
        }
    }

    public synchronized void addWarnings(List<Warning> warnings) {
        for (Warning warning : warnings) {
            if (!this.warningsSeen.add(warning.getWarningCode())) continue;
            this.addWarning(warning);
        }
    }

    public synchronized SQLWarning getWarnings() {
        return this.firstWarning;
    }

    public synchronized void clearWarnings() {
        this.firstWarning = null;
        this.lastWarning = null;
    }
}

