/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.iceberg.puffin.BlobMetadata;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;

public class GenericBlobMetadata
implements org.apache.iceberg.BlobMetadata {
    private final String type;
    private final long sourceSnapshotId;
    private final long sourceSnapshotSequenceNumber;
    private final List<Integer> fields;
    private final Map<String, String> properties;

    public static org.apache.iceberg.BlobMetadata from(BlobMetadata puffinMetadata) {
        return new GenericBlobMetadata(puffinMetadata.type(), puffinMetadata.snapshotId(), puffinMetadata.sequenceNumber(), puffinMetadata.inputFields(), puffinMetadata.properties());
    }

    public static List<org.apache.iceberg.BlobMetadata> from(Collection<BlobMetadata> puffinMetadataList) {
        return (List)puffinMetadataList.stream().map(GenericBlobMetadata::from).collect(ImmutableList.toImmutableList());
    }

    public GenericBlobMetadata(String type, long sourceSnapshotId, long sourceSnapshotSequenceNumber, List<Integer> fields, Map<String, String> properties) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        Preconditions.checkNotNull(fields, (Object)"fields is null");
        Preconditions.checkNotNull(properties, (Object)"properties is null");
        this.type = type;
        this.sourceSnapshotId = sourceSnapshotId;
        this.sourceSnapshotSequenceNumber = sourceSnapshotSequenceNumber;
        this.fields = ImmutableList.copyOf(fields);
        this.properties = ImmutableMap.copyOf(properties);
    }

    public String type() {
        return this.type;
    }

    public long sourceSnapshotId() {
        return this.sourceSnapshotId;
    }

    public long sourceSnapshotSequenceNumber() {
        return this.sourceSnapshotSequenceNumber;
    }

    public List<Integer> fields() {
        return this.fields;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericBlobMetadata that = (GenericBlobMetadata)o;
        return this.sourceSnapshotId == that.sourceSnapshotId && this.sourceSnapshotSequenceNumber == that.sourceSnapshotSequenceNumber && Objects.equals(this.type, that.type) && Objects.equals(this.fields, that.fields) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.sourceSnapshotId, this.sourceSnapshotSequenceNumber, this.fields, this.properties);
    }

    public String toString() {
        return new StringJoiner(", ", GenericBlobMetadata.class.getSimpleName() + "[", "]").add("type='" + this.type + "'").add("sourceSnapshotId=" + this.sourceSnapshotId).add("sourceSnapshotSequenceNumber=" + this.sourceSnapshotSequenceNumber).add("fields=" + String.valueOf(this.fields)).add("properties=" + String.valueOf(this.properties)).toString();
    }
}

