/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.iceberg.service.CatalogWrapperForREST;
import org.apache.gravitino.iceberg.service.IcebergCatalogWrapperManager;
import org.apache.gravitino.iceberg.service.IcebergRESTUtils;
import org.apache.iceberg.rest.Endpoint;
import org.apache.iceberg.rest.responses.ConfigResponse;

@Path(value="/v1/{prefix:([^/]*/)?}config")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IcebergConfigOperations {
    @Context
    private HttpServletRequest httpRequest;
    private final IcebergCatalogWrapperManager catalogWrapperManager;
    private static final List<Endpoint> DEFAULT_ENDPOINTS = ImmutableList.builder().add((Object)Endpoint.V1_LIST_NAMESPACES).add((Object)Endpoint.V1_LOAD_NAMESPACE).add((Object)Endpoint.V1_CREATE_NAMESPACE).add((Object)Endpoint.V1_UPDATE_NAMESPACE).add((Object)Endpoint.V1_DELETE_NAMESPACE).add((Object)Endpoint.V1_NAMESPACE_EXISTS).add((Object)Endpoint.V1_LIST_TABLES).add((Object)Endpoint.V1_LOAD_TABLE).add((Object)Endpoint.V1_CREATE_TABLE).add((Object)Endpoint.V1_UPDATE_TABLE).add((Object)Endpoint.V1_DELETE_TABLE).add((Object)Endpoint.V1_RENAME_TABLE).add((Object)Endpoint.V1_TABLE_EXISTS).add((Object)Endpoint.V1_REGISTER_TABLE).add((Object)Endpoint.V1_REPORT_METRICS).add((Object)Endpoint.V1_TABLE_CREDENTIALS).add((Object)Endpoint.V1_SUBMIT_TABLE_SCAN_PLAN).build();
    private static final List<Endpoint> DEFAULT_VIEW_ENDPOINTS = ImmutableList.builder().add((Object)Endpoint.V1_LIST_VIEWS).add((Object)Endpoint.V1_LOAD_VIEW).add((Object)Endpoint.V1_CREATE_VIEW).add((Object)Endpoint.V1_UPDATE_VIEW).add((Object)Endpoint.V1_DELETE_VIEW).add((Object)Endpoint.V1_RENAME_VIEW).add((Object)Endpoint.V1_VIEW_EXISTS).build();

    @Inject
    public IcebergConfigOperations(IcebergCatalogWrapperManager catalogWrapperManager) {
        this.catalogWrapperManager = catalogWrapperManager;
    }

    @GET
    @Produces(value={"application/json"})
    @Timed(name="config.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="config", absolute=true)
    public Response getConfig(@DefaultValue(value="") @QueryParam(value="warehouse") String warehouse) {
        String catalogName = this.getCatalogName(warehouse);
        boolean supportsView = this.supportsViewOperations(catalogName);
        ConfigResponse.Builder builder = ConfigResponse.builder();
        builder.withDefaults(this.getDefaultConfig(catalogName)).withEndpoints(this.getEndpoints(supportsView));
        if (StringUtils.isNotBlank((CharSequence)warehouse)) {
            builder.withDefault("prefix", warehouse);
        }
        return IcebergRESTUtils.ok(builder.build());
    }

    private List<Endpoint> getEndpoints(boolean supportsViewOperations) {
        if (!supportsViewOperations) {
            return DEFAULT_ENDPOINTS;
        }
        return Stream.concat(DEFAULT_ENDPOINTS.stream(), DEFAULT_VIEW_ENDPOINTS.stream()).collect(Collectors.toList());
    }

    private Map<String, String> getCatalogConfig(String catalogName) {
        HashMap<String, String> configs = new HashMap<String, String>();
        CatalogWrapperForREST catalogWrapper = this.getCatalogWrapper(catalogName);
        configs.putAll(catalogWrapper.getCatalogConfigToClient());
        return configs;
    }

    private String getCatalogName(String warehouse) {
        if (StringUtils.isBlank((CharSequence)warehouse)) {
            return "default_catalog";
        }
        return warehouse;
    }

    private boolean supportsViewOperations(String catalogName) {
        CatalogWrapperForREST catalogWrapperForREST = this.getCatalogWrapper(catalogName);
        return catalogWrapperForREST.supportsViewOperations();
    }

    private CatalogWrapperForREST getCatalogWrapper(String catalogName) {
        return this.catalogWrapperManager.getCatalogWrapper(catalogName);
    }

    protected Map<String, String> getDefaultConfig(String catalogName) {
        return this.getCatalogConfig(catalogName);
    }

    protected ConfigResponse.Builder getConfigResponseBuilder(boolean supportsViewOperations) {
        return ConfigResponse.builder();
    }
}

