/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.JobHistoryFileParser;
import org.apache.hadoop.mapreduce.JobHistoryFileReplayHelper;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TimelineEntityConverterV1;
import org.apache.hadoop.mapreduce.TimelineServicePerformance;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.client.api.TimelineClient;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JobHistoryFileReplayMapperV1
extends Mapper<IntWritable, IntWritable, Writable, Writable> {
    private static final Logger LOG = LoggerFactory.getLogger(JobHistoryFileReplayMapperV1.class);

    JobHistoryFileReplayMapperV1() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void map(IntWritable key, IntWritable val, Mapper.Context context) throws IOException {
        TimelineClient tlc = TimelineClient.createTimelineClient();
        TimelineEntityConverterV1 converter = new TimelineEntityConverterV1();
        JobHistoryFileReplayHelper helper = new JobHistoryFileReplayHelper(context);
        int replayMode = helper.getReplayMode();
        Collection<JobHistoryFileReplayHelper.JobFiles> jobs = helper.getJobFiles();
        JobHistoryFileParser parser = helper.getParser();
        if (jobs.isEmpty()) {
            LOG.info(context.getTaskAttemptID().getTaskID() + " will process no jobs");
        } else {
            LOG.info(context.getTaskAttemptID().getTaskID() + " will process " + jobs.size() + " jobs");
        }
        for (JobHistoryFileReplayHelper.JobFiles job : jobs) {
            String jobIdStr = job.getJobId();
            LOG.info("processing " + jobIdStr + "...");
            JobId jobId = TypeConverter.toYarn((JobID)JobID.forName((String)jobIdStr));
            ApplicationId appId = jobId.getAppId();
            try {
                Path historyFilePath = job.getJobHistoryFilePath();
                Path confFilePath = job.getJobConfFilePath();
                if (historyFilePath == null || confFilePath == null) continue;
                JobHistoryParser.JobInfo jobInfo = parser.parseHistoryFile(historyFilePath);
                Configuration jobConf = parser.parseConfiguration(confFilePath);
                LOG.info("parsed the job history file and the configuration file for job " + jobIdStr);
                long totalTime = 0L;
                Set<TimelineEntity> entitySet = converter.createTimelineEntities(jobInfo, jobConf);
                LOG.info("converted them into timeline entities for job " + jobIdStr);
                UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                long startWrite = System.nanoTime();
                try {
                    switch (replayMode) {
                        case 1: {
                            this.writeAllEntities(tlc, entitySet, ugi);
                            break;
                        }
                        case 2: {
                            this.writePerEntity(tlc, entitySet, ugi);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    context.getCounter((Enum)TimelineServicePerformance.PerfCounters.TIMELINE_SERVICE_WRITE_FAILURES).increment(1L);
                    LOG.error("writing to the timeline service failed", (Throwable)e);
                }
                long endWrite = System.nanoTime();
                int numEntities = entitySet.size();
                LOG.info("wrote " + numEntities + " entities in " + (totalTime += TimeUnit.NANOSECONDS.toMillis(endWrite - startWrite)) + " ms");
                context.getCounter((Enum)TimelineServicePerformance.PerfCounters.TIMELINE_SERVICE_WRITE_TIME).increment(totalTime);
                context.getCounter((Enum)TimelineServicePerformance.PerfCounters.TIMELINE_SERVICE_WRITE_COUNTER).increment((long)numEntities);
            }
            finally {
                context.progress();
            }
        }
    }

    private void writeAllEntities(TimelineClient tlc, Set<TimelineEntity> entitySet, UserGroupInformation ugi) throws IOException, YarnException {
        tlc.putEntities((TimelineEntity[])entitySet.toArray());
    }

    private void writePerEntity(TimelineClient tlc, Set<TimelineEntity> entitySet, UserGroupInformation ugi) throws IOException, YarnException {
        for (TimelineEntity entity : entitySet) {
            tlc.putEntities(new TimelineEntity[]{entity});
            LOG.info("wrote entity " + entity.getEntityId());
        }
    }
}

