/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.executor;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class ContainerLivenessContext {
    private final Container container;
    private final String user;
    private final String pid;

    private ContainerLivenessContext(Builder builder) {
        this.container = builder.container;
        this.user = builder.user;
        this.pid = builder.pid;
    }

    public Container getContainer() {
        return this.container;
    }

    public String getUser() {
        return this.user;
    }

    public String getPid() {
        return this.pid;
    }

    public static final class Builder {
        private Container container;
        private String user;
        private String pid;

        public Builder setContainer(Container container) {
            this.container = container;
            return this;
        }

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }

        public Builder setPid(String pid) {
            this.pid = pid;
            return this;
        }

        public ContainerLivenessContext build() {
            return new ContainerLivenessContext(this);
        }
    }
}

