/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.enums;

import org.apache.hadoop.fs.azurebfs.enums.StatisticTypeEnum;

public enum AbfsBackoffMetricsEnum {
    NUMBER_OF_IOPS_THROTTLED_REQUESTS("numberOfIOPSThrottledRequests", "Number of IOPS throttled requests", "BASE", StatisticTypeEnum.TYPE_COUNTER),
    NUMBER_OF_BANDWIDTH_THROTTLED_REQUESTS("numberOfBandwidthThrottledRequests", "Number of bandwidth throttled requests", "BASE", StatisticTypeEnum.TYPE_COUNTER),
    NUMBER_OF_OTHER_THROTTLED_REQUESTS("numberOfOtherThrottledRequests", "Number of other throttled requests", "BASE", StatisticTypeEnum.TYPE_COUNTER),
    NUMBER_OF_NETWORK_FAILED_REQUESTS("numberOfNetworkFailedRequests", "Number of network failed requests", "BASE", StatisticTypeEnum.TYPE_COUNTER),
    MAX_RETRY_COUNT("maxRetryCount", "Max retry count", "BASE", StatisticTypeEnum.TYPE_COUNTER),
    TOTAL_NUMBER_OF_REQUESTS("totalNumberOfRequests", "Total number of requests", "BASE", StatisticTypeEnum.TYPE_COUNTER),
    NUMBER_OF_REQUESTS_SUCCEEDED_WITHOUT_RETRYING("numberOfRequestsSucceededWithoutRetrying", "Number of requests succeeded without retrying", "BASE", StatisticTypeEnum.TYPE_COUNTER),
    NUMBER_OF_REQUESTS_FAILED("numberOfRequestsFailed", "Number of requests failed", "BASE", StatisticTypeEnum.TYPE_COUNTER),
    NUMBER_OF_REQUESTS_SUCCEEDED("numberOfRequestsSucceeded", "Number of requests succeeded", "RETRY", StatisticTypeEnum.TYPE_COUNTER),
    MIN_BACK_OFF("minBackOff", "Minimum backoff", "RETRY", StatisticTypeEnum.TYPE_GAUGE),
    MAX_BACK_OFF("maxBackOff", "Maximum backoff", "RETRY", StatisticTypeEnum.TYPE_GAUGE),
    TOTAL_BACK_OFF("totalBackoff", "Total backoff", "RETRY", StatisticTypeEnum.TYPE_GAUGE),
    TOTAL_REQUESTS("totalRequests", "Total requests", "RETRY", StatisticTypeEnum.TYPE_COUNTER);

    private final String name;
    private final String description;
    private final String type;
    private final StatisticTypeEnum statisticType;

    private AbfsBackoffMetricsEnum(String name, String description, String type, StatisticTypeEnum statisticType) {
        this.name = name;
        this.description = description;
        this.type = type;
        this.statisticType = statisticType;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public StatisticTypeEnum getStatisticType() {
        return this.statisticType;
    }
}

