/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.CallerContext;
import org.junit.Assert;
import org.junit.Test;

public class TestCallerContext {
    @Test
    public void testBuilderAppend() {
        Configuration conf = new Configuration();
        conf.set("hadoop.caller.context.separator", "$");
        CallerContext.Builder builder = new CallerContext.Builder(null, conf);
        CallerContext context = builder.append("context1").append("context2").append("key3", "value3").build();
        Assert.assertEquals((Object)true, (Object)context.getContext().contains("$"));
        String[] items = context.getContext().split("\\$");
        Assert.assertEquals((long)3L, (long)items.length);
        Assert.assertEquals((Object)"key3:value3", (Object)items[2]);
        builder.append("$$");
        Assert.assertEquals((Object)"context1$context2$key3:value3$$$", (Object)builder.build().getContext());
    }

    @Test
    public void testBuilderAppendIfAbsent() {
        Configuration conf = new Configuration();
        conf.set("hadoop.caller.context.separator", "$");
        CallerContext.Builder builder = new CallerContext.Builder(null, conf);
        builder.append("key1", "value1");
        Assert.assertEquals((Object)"key1:value1", (Object)builder.build().getContext());
        builder.appendIfAbsent("key1", "value2");
        String[] items = builder.build().getContext().split("\\$");
        Assert.assertEquals((long)1L, (long)items.length);
        Assert.assertEquals((Object)"key1:value1", (Object)builder.build().getContext());
        builder.appendIfAbsent("key2", "value2");
        String[] items2 = builder.build().getContext().split("\\$");
        Assert.assertEquals((long)2L, (long)items2.length);
        Assert.assertEquals((Object)"key1:value1$key2:value2", (Object)builder.build().getContext());
        builder.appendIfAbsent("key", "value");
        String[] items3 = builder.build().getContext().split("\\$");
        Assert.assertEquals((long)3L, (long)items3.length);
        Assert.assertEquals((Object)"key1:value1$key2:value2$key:value", (Object)builder.build().getContext());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNewBuilder() {
        Configuration conf = new Configuration();
        conf.set("hadoop.caller.context.separator", "\t");
        CallerContext.Builder builder = new CallerContext.Builder(null, conf);
        builder.build();
    }
}

