/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.S3AStore;
import org.apache.hadoop.fs.s3a.impl.BulkDeleteOperation;
import org.apache.hadoop.fs.store.audit.AuditSpan;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.functional.Tuples;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;

public class BulkDeleteOperationCallbacksImpl
implements BulkDeleteOperation.BulkDeleteOperationCallbacks {
    private final String path;
    private final int pageSize;
    private final AuditSpan span;
    private final S3AStore store;

    public BulkDeleteOperationCallbacksImpl(S3AStore store, String path, int pageSize, AuditSpan span) {
        this.span = span;
        this.pageSize = pageSize;
        this.path = path;
        this.store = store;
    }

    @Override
    public List<Map.Entry<String, String>> bulkDelete(List<ObjectIdentifier> keysToDelete) throws IOException, IllegalArgumentException {
        this.span.activate();
        int size = keysToDelete.size();
        Preconditions.checkArgument((size <= this.pageSize ? 1 : 0) != 0, (String)"Too many paths to delete in one operation: %s", (Object[])new Object[]{size});
        if (size == 0) {
            return Collections.emptyList();
        }
        if (size == 1) {
            return this.deleteSingleObject(keysToDelete.get(0).key());
        }
        DeleteObjectsResponse response = (DeleteObjectsResponse)((Map.Entry)Invoker.once("bulkDelete", this.path, () -> this.store.deleteObjects((DeleteObjectsRequest)this.store.getRequestFactory().newBulkDeleteRequestBuilder(keysToDelete).build()))).getValue();
        List errors = response.errors();
        if (errors.isEmpty()) {
            return Collections.emptyList();
        }
        return errors.stream().map(e -> Tuples.pair((Object)e.key(), (Object)e.toString())).collect(Collectors.toList());
    }

    private List<Map.Entry<String, String>> deleteSingleObject(String key) throws IOException {
        try {
            Invoker.once("bulkDelete", this.path, () -> this.store.deleteObject((DeleteObjectRequest)this.store.getRequestFactory().newDeleteObjectRequestBuilder(key).build()));
        }
        catch (AccessDeniedException e) {
            return Collections.singletonList(Tuples.pair((Object)key, (Object)e.toString()));
        }
        return Collections.emptyList();
    }
}

