/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.sharedcachemanager;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.api.SCMUploaderProtocol;
import org.apache.hadoop.yarn.server.api.protocolrecords.SCMUploaderCanUploadRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.SCMUploaderCanUploadResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.SCMUploaderNotifyRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.SCMUploaderNotifyResponse;
import org.apache.hadoop.yarn.server.sharedcachemanager.metrics.SharedCacheUploaderMetrics;
import org.apache.hadoop.yarn.server.sharedcachemanager.store.SCMStore;

public class SharedCacheUploaderService
extends AbstractService
implements SCMUploaderProtocol {
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private Server server;
    InetSocketAddress bindAddress;
    private final SCMStore store;
    private SharedCacheUploaderMetrics metrics;

    public SharedCacheUploaderService(SCMStore store) {
        super(SharedCacheUploaderService.class.getName());
        this.store = store;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.bindAddress = this.getBindAddress(conf);
        super.serviceInit(conf);
    }

    InetSocketAddress getBindAddress(Configuration conf) {
        return conf.getSocketAddr("yarn.sharedcache.uploader.server.address", "0.0.0.0:8046", 8046);
    }

    protected void serviceStart() throws Exception {
        Configuration conf = this.getConfig();
        this.metrics = SharedCacheUploaderMetrics.getInstance();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        this.server = rpc.getServer(SCMUploaderProtocol.class, (Object)this, this.bindAddress, conf, null, conf.getInt("yarn.sharedcache.uploader.server.thread-count", 50));
        this.server.start();
        this.bindAddress = conf.updateConnectAddr("yarn.sharedcache.uploader.server.address", this.server.getListenerAddress());
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
        super.serviceStop();
    }

    public SCMUploaderNotifyResponse notify(SCMUploaderNotifyRequest request) throws YarnException, IOException {
        SCMUploaderNotifyResponse response = (SCMUploaderNotifyResponse)this.recordFactory.newRecordInstance(SCMUploaderNotifyResponse.class);
        String filename = this.store.addResource(request.getResourceKey(), request.getFileName());
        boolean accepted = filename.equals(request.getFileName());
        if (accepted) {
            this.metrics.incAcceptedUploads();
        } else {
            this.metrics.incRejectedUploads();
        }
        response.setAccepted(accepted);
        return response;
    }

    public SCMUploaderCanUploadResponse canUpload(SCMUploaderCanUploadRequest request) throws YarnException, IOException {
        SCMUploaderCanUploadResponse response = (SCMUploaderCanUploadResponse)this.recordFactory.newRecordInstance(SCMUploaderCanUploadResponse.class);
        response.setUploadable(true);
        return response;
    }
}

