/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor;

import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceUtilization;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.nodemanager.ResourceView;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainersMonitorEvent;

public interface ContainersMonitor
extends Service,
EventHandler<ContainersMonitorEvent>,
ResourceView {
    public ResourceUtilization getContainersUtilization();

    public float getVmemRatio();

    public void subtractNodeResourcesFromResourceUtilization(ResourceUtilization var1);

    public static void increaseResourceUtilization(ContainersMonitor containersMonitor, ResourceUtilization resourceUtil, Resource resource) {
        float vCores = resource.getVirtualCores();
        int vmem = (int)((float)resource.getMemorySize() * containersMonitor.getVmemRatio());
        resourceUtil.addTo((int)resource.getMemorySize(), vmem, vCores);
    }

    public static void decreaseResourceUtilization(ContainersMonitor containersMonitor, ResourceUtilization resourceUtil, Resource resource) {
        float vCores = resource.getVirtualCores();
        int vmem = (int)((float)resource.getMemorySize() * containersMonitor.getVmemRatio());
        resourceUtil.subtractFrom((int)resource.getMemorySize(), vmem, vCores);
    }

    public void setAllocatedResourcesForContainers(Resource var1);
}

