/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.invariants;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.SchedulingEditPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.invariants.InvariantViolationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InvariantsChecker
implements SchedulingEditPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(InvariantsChecker.class);
    public static final String THROW_ON_VIOLATION = "yarn.resourcemanager.invariant-checker.throw-on-violation";
    public static final String INVARIANT_MONITOR_INTERVAL = "yarn.resourcemanager.invariant-checker.monitor-interval";
    private Configuration conf;
    private RMContext context;
    private ResourceScheduler scheduler;
    private boolean throwOnInvariantViolation;
    private long monitoringInterval;

    @Override
    public void init(Configuration config, RMContext rmContext, ResourceScheduler scheduler) {
        this.conf = config;
        this.context = rmContext;
        this.scheduler = scheduler;
        this.throwOnInvariantViolation = this.conf.getBoolean(THROW_ON_VIOLATION, false);
        this.monitoringInterval = this.conf.getLong(INVARIANT_MONITOR_INTERVAL, 1000L);
        LOG.info("Invariant checker " + this.getPolicyName() + " enabled. Monitoring every " + this.monitoringInterval + "ms, throwOnViolation=" + this.throwOnInvariantViolation);
    }

    @Override
    public long getMonitoringInterval() {
        return this.monitoringInterval;
    }

    @Override
    public String getPolicyName() {
        return this.getClass().getSimpleName();
    }

    public void logOrThrow(String message) throws InvariantViolationException {
        if (this.getThrowOnInvariantViolation()) {
            throw new InvariantViolationException(message);
        }
        LOG.warn(message);
    }

    public boolean getThrowOnInvariantViolation() {
        return this.throwOnInvariantViolation;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public RMContext getContext() {
        return this.context;
    }

    public ResourceScheduler getScheduler() {
        return this.scheduler;
    }
}

