/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.shaded.org.apache.commons.lang3.math.NumberUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.util.AbstractLivelinessMonitor;
import org.apache.hadoop.yarn.util.Clock;

public class AMLivelinessMonitor
extends AbstractLivelinessMonitor<ApplicationAttemptId> {
    private EventHandler<Event> dispatcher;

    public AMLivelinessMonitor(Dispatcher d) {
        super("AMLivelinessMonitor");
        this.dispatcher = d.getEventHandler();
    }

    public AMLivelinessMonitor(Dispatcher d, Clock clock) {
        super("AMLivelinessMonitor", clock);
        this.dispatcher = d.getEventHandler();
    }

    public void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        String rmAmExpiryIntervalMS = conf.get("yarn.am.liveness-monitor.expiry-interval-ms");
        long expireIntvl = NumberUtils.isDigits((String)rmAmExpiryIntervalMS) ? conf.getLong("yarn.am.liveness-monitor.expiry-interval-ms", YarnConfiguration.DEFAULT_RM_AM_EXPIRY_INTERVAL_MS) : conf.getTimeDuration("yarn.am.liveness-monitor.expiry-interval-ms", YarnConfiguration.DEFAULT_RM_AM_EXPIRY_INTERVAL_MS, TimeUnit.MILLISECONDS);
        this.setExpireInterval(expireIntvl);
        this.setMonitorInterval(expireIntvl / 3L);
    }

    protected void expire(ApplicationAttemptId id) {
        this.dispatcher.handle((Event)new RMAppAttemptEvent(id, RMAppAttemptEventType.EXPIRE));
    }
}

