/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.URI;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DeadNodeDetector;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestDeadNodeDetection {
    private MiniDFSCluster cluster;
    private Configuration conf;

    @Before
    public void setUp() {
        this.cluster = null;
        this.conf = new HdfsConfiguration();
        this.conf.setBoolean("dfs.client.deadnode.detection.enabled", true);
        this.conf.setLong("dfs.client.deadnode.detection.probe.deadnode.interval.ms", 1000L);
        this.conf.setLong("dfs.client.deadnode.detection.probe.suspectnode.interval.ms", 100L);
        this.conf.setLong("dfs.client.deadnode.detection.probe.connection.timeout.ms", 1000L);
        this.conf.setInt("dfs.client.max.block.acquire.failures", 0);
        this.conf.setLong("dfs.client.deadnode.detection.idle.sleep.ms", 100L);
    }

    @After
    public void tearDown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeadNodeDetectionInBackground() throws Exception {
        this.conf.set("dfs.client.context", "testDeadNodeDetectionInBackground");
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        this.cluster.waitActive();
        DistributedFileSystem fs = this.cluster.getFileSystem();
        Path filePath = new Path("/testDetectDeadNodeInBackground");
        byte[] bytes = new byte[256];
        for (int index = 0; index < bytes.length; ++index) {
            bytes[index] = 48;
        }
        FSDataOutputStream out = fs.create(filePath, true, 4096, (short)3, 512L);
        out.write(bytes);
        out.write(bytes);
        out.hflush();
        out.close();
        this.cluster.stopDataNode(0);
        this.cluster.stopDataNode(0);
        this.cluster.stopDataNode(0);
        FSDataInputStream in = fs.open(filePath);
        DFSInputStream din = (DFSInputStream)in.getWrappedStream();
        DFSClient dfsClient = din.getDFSClient();
        try {
            try {
                in.read();
            }
            catch (BlockMissingException blockMissingException) {
                // empty catch block
            }
            DefaultCoordination defaultCoordination = new DefaultCoordination();
            defaultCoordination.startWaitForDeadNodeThread(dfsClient, 3);
            defaultCoordination.sync();
            Assert.assertEquals((long)3L, (long)dfsClient.getDeadNodes(din).size());
            Assert.assertEquals((long)3L, (long)dfsClient.getClientContext().getDeadNodeDetector().clearAndGetDetectedDeadNodes().size());
        }
        finally {
            in.close();
            fs.delete(filePath, true);
            Assert.assertEquals((long)0L, (long)dfsClient.getDeadNodes(din).size());
            Assert.assertEquals((long)0L, (long)dfsClient.getClientContext().getDeadNodeDetector().clearAndGetDetectedDeadNodes().size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeadNodeDetectionInMultipleDFSInputStream() throws IOException {
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();
        this.cluster.waitActive();
        DistributedFileSystem fs = this.cluster.getFileSystem();
        Path filePath = new Path("/testDeadNodeMultipleDFSInputStream");
        this.createFile((FileSystem)fs, filePath);
        String datanodeUuid = this.cluster.getDataNodes().get(0).getDatanodeUuid();
        FSDataInputStream in1 = fs.open(filePath);
        DFSInputStream din1 = (DFSInputStream)in1.getWrappedStream();
        DFSClient dfsClient1 = din1.getDFSClient();
        this.cluster.stopDataNode(0);
        FSDataInputStream in2 = fs.open(filePath);
        DFSInputStream din2 = null;
        DFSClient dfsClient2 = null;
        try {
            try {
                in1.read();
            }
            catch (BlockMissingException blockMissingException) {
                // empty catch block
            }
            din2 = (DFSInputStream)in2.getWrappedStream();
            dfsClient2 = din2.getDFSClient();
            DefaultCoordination defaultCoordination = new DefaultCoordination();
            defaultCoordination.startWaitForDeadNodeThread(dfsClient2, 1);
            defaultCoordination.sync();
            Assert.assertEquals((Object)dfsClient1.toString(), (Object)dfsClient2.toString());
            Assert.assertEquals((long)1L, (long)dfsClient1.getDeadNodes(din1).size());
            Assert.assertEquals((long)1L, (long)dfsClient2.getDeadNodes(din2).size());
            Assert.assertEquals((long)1L, (long)dfsClient1.getClientContext().getDeadNodeDetector().clearAndGetDetectedDeadNodes().size());
            Assert.assertEquals((long)1L, (long)dfsClient2.getClientContext().getDeadNodeDetector().clearAndGetDetectedDeadNodes().size());
            Assert.assertEquals((Object)datanodeUuid, (Object)((DatanodeInfo)dfsClient1.getClientContext().getDeadNodeDetector().clearAndGetDetectedDeadNodes().toArray()[0]).getDatanodeUuid());
            Assert.assertEquals((Object)datanodeUuid, (Object)((DatanodeInfo)dfsClient2.getClientContext().getDeadNodeDetector().clearAndGetDetectedDeadNodes().toArray()[0]).getDatanodeUuid());
        }
        finally {
            in1.close();
            in2.close();
            this.deleteFile((FileSystem)fs, filePath);
            Assert.assertEquals((long)0L, (long)dfsClient1.getDeadNodes(din1).size());
            Assert.assertEquals((long)0L, (long)dfsClient2.getDeadNodes(din2).size());
            Assert.assertEquals((long)0L, (long)dfsClient1.getClientContext().getDeadNodeDetector().clearAndGetDetectedDeadNodes().size());
            Assert.assertEquals((long)0L, (long)dfsClient2.getClientContext().getDeadNodeDetector().clearAndGetDetectedDeadNodes().size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeadNodeDetectionDeadNodeRecovery() throws Exception {
        DFSClient.setDisabledStopDeadNodeDetectorThreadForTest((boolean)true);
        this.conf.set("dfs.client.context", "testDeadNodeDetectionDeadNodeRecovery");
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        this.cluster.waitActive();
        DFSClient.setDisabledStopDeadNodeDetectorThreadForTest((boolean)false);
        DistributedFileSystem fs = this.cluster.getFileSystem();
        Path filePath = new Path("/testDeadNodeDetectionDeadNodeRecovery");
        this.createFile((FileSystem)fs, filePath);
        MiniDFSCluster.DataNodeProperties one = this.cluster.stopDataNode(0);
        this.cluster.stopDataNode(0);
        this.cluster.stopDataNode(0);
        FSDataInputStream in = fs.open(filePath);
        DFSInputStream din = (DFSInputStream)in.getWrappedStream();
        DFSClient dfsClient = din.getDFSClient();
        try {
            try {
                in.read();
            }
            catch (BlockMissingException blockMissingException) {
                // empty catch block
            }
            DefaultCoordination defaultCoordination = new DefaultCoordination();
            defaultCoordination.startWaitForDeadNodeThread(dfsClient, 3);
            defaultCoordination.sync();
            Assert.assertEquals((long)3L, (long)dfsClient.getDeadNodes(din).size());
            Assert.assertEquals((long)3L, (long)dfsClient.getClientContext().getDeadNodeDetector().clearAndGetDetectedDeadNodes().size());
            this.cluster.restartDataNode(one, true);
            defaultCoordination = new DefaultCoordination();
            defaultCoordination.startWaitForDeadNodeThread(dfsClient, 2);
            defaultCoordination.sync();
            Assert.assertEquals((long)2L, (long)dfsClient.getDeadNodes(din).size());
            Assert.assertEquals((long)2L, (long)dfsClient.getClientContext().getDeadNodeDetector().clearAndGetDetectedDeadNodes().size());
        }
        finally {
            in.close();
            this.deleteFile((FileSystem)fs, filePath);
            Assert.assertEquals((long)0L, (long)dfsClient.getDeadNodes(din).size());
            Assert.assertEquals((long)0L, (long)dfsClient.getClientContext().getDeadNodeDetector().clearAndGetDetectedDeadNodes().size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testDeadNodeDetectionDeadNodeProbe() throws Exception {
        Path filePath;
        DistributedFileSystem fs;
        block6: {
            fs = null;
            FSDataInputStream in = null;
            filePath = new Path("/" + GenericTestUtils.getMethodName());
            try {
                this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
                this.cluster.waitActive();
                fs = this.cluster.getFileSystem();
                this.createFile((FileSystem)fs, filePath);
                this.cluster.stopDataNode(0);
                this.cluster.stopDataNode(0);
                this.cluster.stopDataNode(0);
                in = fs.open(filePath);
                DFSInputStream din = (DFSInputStream)in.getWrappedStream();
                DFSClient dfsClient = din.getDFSClient();
                DeadNodeDetector deadNodeDetector = dfsClient.getClientContext().getDeadNodeDetector();
                DeadNodeDetector.UniqueQueue queue = deadNodeDetector.getSuspectNodesProbeQueue();
                DeadNodeDetector.UniqueQueue suspectSpy = (DeadNodeDetector.UniqueQueue)Mockito.spy((Object)queue);
                deadNodeDetector.setSuspectQueue(suspectSpy);
                queue = deadNodeDetector.getDeadNodesProbeQueue();
                DeadNodeDetector.UniqueQueue deadSpy = (DeadNodeDetector.UniqueQueue)Mockito.spy((Object)queue);
                deadNodeDetector.setDeadQueue(deadSpy);
                try {
                    in.read();
                }
                catch (BlockMissingException blockMissingException) {
                    // empty catch block
                }
                Thread.sleep(1500L);
                Set deadNodes = dfsClient.getDeadNodeDetector().clearAndGetDetectedDeadNodes();
                Assert.assertEquals((long)3L, (long)deadNodes.size());
                for (DatanodeInfo dead : deadNodes) {
                    ((DeadNodeDetector.UniqueQueue)Mockito.verify((Object)suspectSpy, (VerificationMode)Mockito.times((int)1))).offer((Object)dead);
                    ((DeadNodeDetector.UniqueQueue)Mockito.verify((Object)deadSpy, (VerificationMode)Mockito.atLeastOnce())).offer((Object)dead);
                    ((DeadNodeDetector.UniqueQueue)Mockito.verify((Object)deadSpy, (VerificationMode)Mockito.atLeastOnce())).poll();
                }
                if (in == null) break block6;
            }
            catch (Throwable throwable) {
                if (in != null) {
                    in.close();
                }
                this.deleteFile((FileSystem)fs, filePath);
                throw throwable;
            }
            in.close();
        }
        this.deleteFile((FileSystem)fs, filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeadNodeDetectionSuspectNode() throws Exception {
        DeadNodeDetector.setDisabledProbeThreadForTest((boolean)true);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();
        this.cluster.waitActive();
        DistributedFileSystem fs = this.cluster.getFileSystem();
        Path filePath = new Path("/testDeadNodeDetectionSuspectNode");
        this.createFile((FileSystem)fs, filePath);
        MiniDFSCluster.DataNodeProperties one = this.cluster.stopDataNode(0);
        FSDataInputStream in = fs.open(filePath);
        DFSInputStream din = (DFSInputStream)in.getWrappedStream();
        DFSClient dfsClient = din.getDFSClient();
        DeadNodeDetector deadNodeDetector = dfsClient.getClientContext().getDeadNodeDetector();
        try {
            try {
                in.read();
            }
            catch (BlockMissingException blockMissingException) {
                // empty catch block
            }
            this.waitForSuspectNode(din.getDFSClient());
            this.cluster.restartDataNode(one, true);
            Assert.assertEquals((long)1L, (long)deadNodeDetector.getSuspectNodesProbeQueue().size());
            Assert.assertEquals((long)0L, (long)deadNodeDetector.clearAndGetDetectedDeadNodes().size());
            deadNodeDetector.startProbeScheduler();
            Thread.sleep(1000L);
            Assert.assertEquals((long)0L, (long)deadNodeDetector.getSuspectNodesProbeQueue().size());
            Assert.assertEquals((long)0L, (long)deadNodeDetector.clearAndGetDetectedDeadNodes().size());
        }
        finally {
            in.close();
            this.deleteFile((FileSystem)fs, filePath);
            Assert.assertEquals((long)0L, (long)dfsClient.getDeadNodes(din).size());
            Assert.assertEquals((long)0L, (long)dfsClient.getClientContext().getDeadNodeDetector().clearAndGetDetectedDeadNodes().size());
            DeadNodeDetector.setDisabledProbeThreadForTest((boolean)false);
        }
    }

    @Test
    public void testCloseDeadNodeDetector() throws Exception {
        DistributedFileSystem dfs0 = (DistributedFileSystem)FileSystem.newInstance((URI)new URI("hdfs://127.0.0.1:2001/"), (Configuration)this.conf);
        DistributedFileSystem dfs1 = (DistributedFileSystem)FileSystem.newInstance((URI)new URI("hdfs://127.0.0.1:2001/"), (Configuration)this.conf);
        DeadNodeDetector detector = dfs0.getClient().getDeadNodeDetector();
        Assert.assertNotNull((Object)detector);
        Assert.assertSame((Object)detector, (Object)dfs1.getClient().getDeadNodeDetector());
        dfs0.close();
        detector = dfs0.getClient().getDeadNodeDetector();
        Assert.assertNotNull((Object)detector);
        Assert.assertSame((Object)detector, (Object)dfs1.getClient().getDeadNodeDetector());
        Assert.assertTrue((boolean)detector.isAlive());
        dfs1.close();
        detector = dfs0.getClient().getDeadNodeDetector();
        Assert.assertNull((Object)detector);
        Assert.assertSame((Object)detector, (Object)dfs1.getClient().getDeadNodeDetector());
        dfs1 = (DistributedFileSystem)FileSystem.newInstance((URI)new URI("hdfs://127.0.0.1:2001/"), (Configuration)this.conf);
        DeadNodeDetector newDetector = dfs0.getClient().getDeadNodeDetector();
        Assert.assertNotNull((Object)newDetector);
        Assert.assertTrue((boolean)newDetector.isAlive());
        Assert.assertNotSame((Object)detector, (Object)newDetector);
        dfs1.close();
    }

    @Test
    public void testDeadNodeDetectorThreadsShutdown() throws Exception {
        DistributedFileSystem dfs = (DistributedFileSystem)FileSystem.newInstance((URI)new URI("hdfs://127.0.0.1:2001/"), (Configuration)this.conf);
        DeadNodeDetector detector = dfs.getClient().getDeadNodeDetector();
        Assert.assertNotNull((Object)detector);
        dfs.close();
        Assert.assertTrue((boolean)detector.isThreadsShutdown());
        detector = dfs.getClient().getDeadNodeDetector();
        Assert.assertNull((Object)detector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFile(FileSystem fs, Path filePath) throws IOException {
        try (FSDataOutputStream out = null;){
            byte[] bytes = new byte[256];
            for (int index = 0; index < bytes.length; ++index) {
                bytes[index] = 48;
            }
            out = fs.create(filePath, true, 4096, (short)3, 512L);
            out.write(bytes);
            out.write(bytes);
            out.hflush();
        }
    }

    private void deleteFile(FileSystem fs, Path filePath) throws IOException {
        fs.delete(filePath, true);
    }

    private void waitForSuspectNode(final DFSClient dfsClient) throws Exception {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                try {
                    if (dfsClient.getClientContext().getDeadNodeDetector().getSuspectNodesProbeQueue().size() > 0) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        }, (long)500L, (long)5000L);
    }

    class DefaultCoordination {
        private Queue<Object> queue = new LinkedBlockingQueue<Object>(1);

        DefaultCoordination() {
        }

        public boolean addToQueue() {
            return this.queue.offer(new Object());
        }

        public Object removeFromQueue() {
            return this.queue.poll();
        }

        public void sync() {
            while (this.removeFromQueue() == null) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private void startWaitForDeadNodeThread(DFSClient dfsClient, int size) {
            new Thread(() -> {
                DeadNodeDetector deadNodeDetector = dfsClient.getClientContext().getDeadNodeDetector();
                while (deadNodeDetector.clearAndGetDetectedDeadNodes().size() != size) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.addToQueue();
            }).start();
        }
    }
}

