/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.aliasmap;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.qjournal.TestSecureNNWithQJM;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.common.blockaliasmap.BlockAliasMap;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSecureAliasMap {
    private static HdfsConfiguration baseConf;
    private static File baseDir;
    private static MiniKdc kdc;
    private static String keystoresDir;
    private static String sslConfDir;
    private MiniDFSCluster cluster;
    private HdfsConfiguration conf;
    private FileSystem fs;

    @BeforeClass
    public static void init() throws Exception {
        baseDir = GenericTestUtils.getTestDir((String)TestSecureAliasMap.class.getSimpleName());
        FileUtil.fullyDelete((File)baseDir);
        Assert.assertTrue((boolean)baseDir.mkdirs());
        Properties kdcConf = MiniKdc.createConf();
        kdc = new MiniKdc(kdcConf, baseDir);
        kdc.start();
        baseConf = new HdfsConfiguration();
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)baseConf);
        UserGroupInformation.setConfiguration((Configuration)baseConf);
        Assert.assertTrue((String)"Expected configuration to enable security", (boolean)UserGroupInformation.isSecurityEnabled());
        String userName = UserGroupInformation.getLoginUser().getShortUserName();
        File keytabFile = new File(baseDir, userName + ".keytab");
        String keytab = keytabFile.getAbsolutePath();
        String krbInstance = Path.WINDOWS ? "127.0.0.1" : "localhost";
        kdc.createPrincipal(keytabFile, new String[]{userName + "/" + krbInstance, "HTTP/" + krbInstance});
        keystoresDir = baseDir.getAbsolutePath();
        sslConfDir = KeyStoreTestUtil.getClasspathDir(TestSecureNNWithQJM.class);
        MiniDFSCluster.setupKerberosConfiguration((Configuration)baseConf, userName, kdc.getRealm(), keytab, keystoresDir, sslConfDir);
    }

    @AfterClass
    public static void destroy() throws Exception {
        if (kdc != null) {
            kdc.stop();
        }
        FileUtil.fullyDelete((File)baseDir);
        KeyStoreTestUtil.cleanupSSLConfig((String)keystoresDir, (String)sslConfDir);
    }

    @After
    public void shutdown() throws IOException {
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{this.fs});
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testSecureConnectionToAliasMap() throws Exception {
        this.conf = new HdfsConfiguration((Configuration)baseConf);
        MiniDFSCluster.setupNamenodeProvidedConfiguration((Configuration)this.conf);
        this.conf.set("dfs.provided.aliasmap.inmemory.dnrpc-address", "127.0.0.1:" + NetUtils.getFreeSocketPort());
        int numNodes = 1;
        this.cluster = new MiniDFSCluster.Builder((Configuration)this.conf).numDataNodes(numNodes).storageTypes(new StorageType[]{StorageType.DISK, StorageType.PROVIDED}).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        FSNamesystem namesystem = this.cluster.getNamesystem();
        BlockManager blockManager = namesystem.getBlockManager();
        DataNode dn = this.cluster.getDataNodes().get(0);
        FsDatasetSpi.FsVolumeReferences volumes = dn.getFSDataset().getFsVolumeReferences();
        FsVolumeSpi providedVolume = null;
        for (FsVolumeSpi volume : volumes) {
            if (!volume.getStorageType().equals((Object)StorageType.PROVIDED)) continue;
            providedVolume = volume;
            break;
        }
        String[] bps = providedVolume.getBlockPoolList();
        Assert.assertEquals((String)"Missing provided volume", (long)1L, (long)bps.length);
        BlockAliasMap aliasMap = blockManager.getProvidedStorageMap().getAliasMap();
        BlockAliasMap.Reader reader = aliasMap.getReader(null, bps[0]);
        Assert.assertNotNull((String)"Failed to create blockAliasMap reader", (Object)reader);
    }
}

