/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.eclipse.jetty.util.ajax.JSON;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestStorageBlockPoolUsageStdDev {
    private static final int NUM_DATANODES = 5;
    private static final int STORAGES_PER_DATANODE = 3;
    private static final int DEFAULT_BLOCK_SIZE = 102400;
    private static final int BUFFER_LENGTH = 1024;
    private static Configuration conf;
    private MiniDFSCluster cluster;
    private FileSystem fs;

    @Before
    public void setup() throws Exception {
        conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", 102400L);
        long capacity = 819200L;
        long[][] capacities = new long[5][3];
        String[] hostnames = new String[5];
        for (int i = 0; i < 5; ++i) {
            hostnames[i] = i + "." + i + "." + i + "." + i;
            for (int j = 0; j < 3; ++j) {
                capacities[i][j] = capacity;
            }
        }
        this.cluster = new MiniDFSCluster.Builder(conf).hosts(hostnames).numDataNodes(5).storagesPerDatanode(3).storageCapacities(capacities).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
    }

    @Test
    public void testStorageBlockPoolUsageStdDev() throws IOException {
        ArrayList<DataNode> dataNodes = this.cluster.getDataNodes();
        DataNode dn0 = dataNodes.get(0);
        DataNode dn1 = dataNodes.get(1);
        DataNode dn2 = dataNodes.get(2);
        DataNode dn3 = dataNodes.get(3);
        DataNode dn4 = dataNodes.get(4);
        DFSTestUtil.createFile(this.fs, new Path("/file0"), false, 1024, 1000L, 102400L, (short)1, 0L, false, new InetSocketAddress[]{dn0.getXferAddress()});
        DFSTestUtil.createFile(this.fs, new Path("/file1"), false, 1024, 2000L, 102400L, (short)1, 0L, false, new InetSocketAddress[]{dn1.getXferAddress()});
        DFSTestUtil.createFile(this.fs, new Path("/file2"), false, 1024, 4000L, 102400L, (short)1, 0L, false, new InetSocketAddress[]{dn2.getXferAddress()});
        DFSTestUtil.createFile(this.fs, new Path("/file3"), false, 1024, 8000L, 102400L, (short)1, 0L, false, new InetSocketAddress[]{dn3.getXferAddress()});
        DFSTestUtil.createFile(this.fs, new Path("/file4"), false, 1024, 16000L, 102400L, (short)1, 0L, false, new InetSocketAddress[]{dn4.getXferAddress()});
        this.cluster.triggerHeartbeats();
        String liveNodes = this.cluster.getNameNode().getNamesystem().getLiveNodes();
        Map info = (Map)JSON.parse((String)liveNodes);
        FSNamesystem namesystem = this.cluster.getNamesystem();
        String blockPoolId = namesystem.getBlockPoolId();
        StorageReport[] storageReportsDn0 = dn0.getFSDataset().getStorageReports(blockPoolId);
        StorageReport[] storageReportsDn1 = dn1.getFSDataset().getStorageReports(blockPoolId);
        StorageReport[] storageReportsDn2 = dn2.getFSDataset().getStorageReports(blockPoolId);
        StorageReport[] storageReportsDn3 = dn3.getFSDataset().getStorageReports(blockPoolId);
        StorageReport[] storageReportsDn4 = dn4.getFSDataset().getStorageReports(blockPoolId);
        Assert.assertEquals((double)Util.getBlockPoolUsedPercentStdDev((StorageReport[])storageReportsDn0), (double)((Double)((Map)info.get(dn0.getDisplayName())).get("blockPoolUsedPercentStdDev")), (double)0.01);
        Assert.assertEquals((double)Util.getBlockPoolUsedPercentStdDev((StorageReport[])storageReportsDn1), (double)((Double)((Map)info.get(dn1.getDisplayName())).get("blockPoolUsedPercentStdDev")), (double)0.01);
        Assert.assertEquals((double)Util.getBlockPoolUsedPercentStdDev((StorageReport[])storageReportsDn2), (double)((Double)((Map)info.get(dn2.getDisplayName())).get("blockPoolUsedPercentStdDev")), (double)0.01);
        Assert.assertEquals((double)Util.getBlockPoolUsedPercentStdDev((StorageReport[])storageReportsDn3), (double)((Double)((Map)info.get(dn3.getDisplayName())).get("blockPoolUsedPercentStdDev")), (double)0.01);
        Assert.assertEquals((double)Util.getBlockPoolUsedPercentStdDev((StorageReport[])storageReportsDn4), (double)((Double)((Map)info.get(dn4.getDisplayName())).get("blockPoolUsedPercentStdDev")), (double)0.01);
    }
}

