/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.namenode.NameNodeUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestClientNameNodeAddress {
    public static final Logger LOG = LoggerFactory.getLogger(TestClientNameNodeAddress.class);
    @Rule
    public Timeout globalTimeout = new Timeout(300000);

    @Test
    public void testSimpleConfig() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("fs.defaultFS", "hdfs://host1:100");
        Assert.assertThat((Object)NameNodeUtils.getClientNamenodeAddress((Configuration)conf, null), (Matcher)CoreMatchers.is((Object)"host1:100"));
    }

    @Test
    public void testSimpleWithoutPort() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("fs.defaultFS", "hdfs://host1");
        Assert.assertNull((Object)NameNodeUtils.getClientNamenodeAddress((Configuration)conf, null));
    }

    @Test
    public void testWithNoDefaultFs() {
        HdfsConfiguration conf = new HdfsConfiguration();
        Assert.assertNull((Object)NameNodeUtils.getClientNamenodeAddress((Configuration)conf, null));
    }

    @Test
    public void testWithNoHost() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("fs.defaultFS", "hdfs:///");
        Assert.assertNull((Object)NameNodeUtils.getClientNamenodeAddress((Configuration)conf, null));
    }

    @Test
    public void testFederationWithHa() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("fs.defaultFS", "hdfs://ns1");
        conf.set("dfs.nameservices", "ns1,ns2");
        conf.set("dfs.ha.namenodes.ns1", "nn1,nn2");
        conf.set("dfs.ha.namenodes.ns2", "nn1,nn2");
        Assert.assertThat((Object)NameNodeUtils.getClientNamenodeAddress((Configuration)conf, (String)"ns1"), (Matcher)CoreMatchers.is((Object)"ns1"));
        Assert.assertThat((Object)NameNodeUtils.getClientNamenodeAddress((Configuration)conf, (String)"ns2"), (Matcher)CoreMatchers.is((Object)"ns2"));
    }

    @Test
    public void testFederationWithoutHa() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("fs.defaultFS", "hdfs://host1:100");
        conf.set("dfs.nameservices", "ns1,ns2");
        conf.set("dfs.namenode.rpc-address.ns1", "host1:100");
        conf.set("dfs.namenode.rpc-address.ns2", "host2:200");
        Assert.assertThat((Object)NameNodeUtils.getClientNamenodeAddress((Configuration)conf, (String)"ns1"), (Matcher)CoreMatchers.is((Object)"host1:100"));
        Assert.assertThat((Object)NameNodeUtils.getClientNamenodeAddress((Configuration)conf, (String)"ns2"), (Matcher)CoreMatchers.is((Object)"host2:200"));
    }
}

