/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.top.window;

import org.apache.hadoop.hdfs.server.namenode.top.window.RollingWindow;
import org.junit.Assert;
import org.junit.Test;

public class TestRollingWindow {
    final int WINDOW_LEN = 60000;
    final int BUCKET_CNT = 10;
    final int BUCKET_LEN = 6000;

    @Test
    public void testBasics() {
        RollingWindow window = new RollingWindow(60000, 10);
        long time = 1L;
        Assert.assertEquals((String)"The initial sum of rolling window must be 0", (long)0L, (long)window.getSum(time));
        time = 69000L;
        Assert.assertEquals((String)"The initial sum of rolling window must be 0", (long)0L, (long)window.getSum(time));
        window.incAt(time, 5L);
        Assert.assertEquals((String)"The sum of rolling window does not reflect the recent update", (long)5L, (long)window.getSum(time));
        window.incAt(time += 6000L, 6L);
        Assert.assertEquals((String)"The sum of rolling window does not reflect the recent update", (long)11L, (long)window.getSum(time));
        Assert.assertEquals((String)"The sum of rolling window does not reflect rolling effect", (long)6L, (long)window.getSum(time += 54000L));
        Assert.assertEquals((String)"The sum of rolling window does not reflect rolling effect", (long)0L, (long)window.getSum(time += 6000L));
    }

    @Test
    public void testReorderedAccess() {
        RollingWindow window = new RollingWindow(60000, 10);
        long time = 129000L;
        window.incAt(time, 5L);
        Assert.assertEquals((String)"The sum of rolling window does not reflect the recent update", (long)5L, (long)window.getSum(++time));
        long reorderedTime = time - 12000L;
        window.incAt(reorderedTime, 6L);
        Assert.assertEquals((String)"The sum of rolling window does not reflect the reordered update", (long)11L, (long)window.getSum(time));
        time = reorderedTime + 60000L;
        Assert.assertEquals((String)"The sum of rolling window does not reflect rolling effect", (long)5L, (long)window.getSum(time));
    }
}

