/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.rumen.JobTraceReader;
import org.apache.hadoop.tools.rumen.LoggedJob;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.sls.AMDefinition;
import org.apache.hadoop.yarn.sls.AMDefinitionFactory;
import org.apache.hadoop.yarn.sls.AMDefinitionRumen;
import org.apache.hadoop.yarn.sls.AMDefinitionSLS;
import org.apache.hadoop.yarn.sls.AMDefinitionSynth;
import org.apache.hadoop.yarn.sls.JobDefinition;
import org.apache.hadoop.yarn.sls.SLSRunner;
import org.apache.hadoop.yarn.sls.appmaster.AMSimulator;
import org.apache.hadoop.yarn.sls.scheduler.TaskRunner;
import org.apache.hadoop.yarn.sls.synthetic.SynthJob;
import org.apache.hadoop.yarn.sls.synthetic.SynthTraceJobProducer;
import org.apache.hadoop.yarn.util.UTCClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMRunner {
    private static final Logger LOG = LoggerFactory.getLogger(AMRunner.class);
    int remainingApps = 0;
    private final Configuration conf;
    private int AM_ID;
    private Map<String, AMSimulator> amMap;
    private Map<ApplicationId, AMSimulator> appIdAMSim;
    private Set<String> trackedApps;
    private Map<String, Class> amClassMap;
    private SLSRunner.TraceType inputType;
    private String[] inputTraces;
    private final TaskRunner runner;
    private final SLSRunner slsRunner;
    private int numAMs;
    private int numTasks;
    private long maxRuntime;
    private ResourceManager rm;

    public AMRunner(TaskRunner runner, SLSRunner slsRunner) {
        this.runner = runner;
        this.slsRunner = slsRunner;
        this.conf = slsRunner.getConf();
    }

    public void init(Configuration conf) throws ClassNotFoundException {
        this.amMap = new ConcurrentHashMap<String, AMSimulator>();
        this.amClassMap = new HashMap<String, Class>();
        this.appIdAMSim = new ConcurrentHashMap<ApplicationId, AMSimulator>();
        for (Map.Entry e : conf) {
            String key = (String)e.getKey();
            if (!key.startsWith("yarn.sls.am.type.")) continue;
            String amType = key.substring("yarn.sls.am.type.".length());
            this.amClassMap.put(amType, Class.forName(conf.get(key)));
        }
    }

    public void startAM() throws YarnException, IOException {
        switch (this.inputType) {
            case SLS: {
                for (String inputTrace : this.inputTraces) {
                    this.startAMFromSLSTrace(inputTrace);
                }
                break;
            }
            case RUMEN: {
                long baselineTimeMS = 0L;
                for (String inputTrace : this.inputTraces) {
                    this.startAMFromRumenTrace(inputTrace, baselineTimeMS);
                }
                break;
            }
            case SYNTH: {
                this.startAMFromSynthGenerator();
                break;
            }
            default: {
                throw new YarnException("Input configuration not recognized, trace type should be SLS, RUMEN, or SYNTH");
            }
        }
        this.remainingApps = this.numAMs = this.amMap.size();
    }

    private void startAMFromSLSTrace(String inputTrace) throws IOException {
        JsonFactory jsonF = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper();
        try (InputStreamReader input = new InputStreamReader((InputStream)new FileInputStream(inputTrace), StandardCharsets.UTF_8);){
            MapType type = mapper.getTypeFactory().constructMapType(Map.class, String.class, String.class);
            MappingIterator jobIter = mapper.readValues(jsonF.createParser((Reader)input), (JavaType)type);
            while (jobIter.hasNext()) {
                try {
                    Map jsonJob = (Map)jobIter.next();
                    AMDefinitionSLS amDef = AMDefinitionFactory.createFromSlsTrace(jsonJob, this.slsRunner);
                    this.startAMs(amDef);
                }
                catch (Exception e) {
                    LOG.error("Failed to create an AM: {}", (Object)e.getMessage());
                }
            }
        }
    }

    private void startAMFromSynthGenerator() throws YarnException, IOException {
        SynthJob job;
        Configuration localConf = new Configuration();
        localConf.set("fs.defaultFS", "file:///");
        if (this.slsRunner.getStjp() == null) {
            this.slsRunner.setStjp(new SynthTraceJobProducer(this.conf, new Path(this.inputTraces[0])));
        }
        while ((job = (SynthJob)this.slsRunner.getStjp().getNextJob()) != null) {
            ReservationId reservationId = null;
            if (job.hasDeadline()) {
                reservationId = ReservationId.newInstance((long)this.rm.getStartTime(), (long)this.AM_ID);
            }
            AMDefinitionSynth amDef = AMDefinitionFactory.createFromSynth(job, this.slsRunner);
            this.startAMs(amDef, reservationId, job.getParams(), job.getDeadline());
        }
    }

    private void startAMFromRumenTrace(String inputTrace, long baselineTimeMS) throws IOException {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        File fin = new File(inputTrace);
        try (JobTraceReader reader = new JobTraceReader(new Path(fin.getAbsolutePath()), conf);){
            LoggedJob job = (LoggedJob)reader.getNext();
            while (job != null) {
                try {
                    AMDefinitionRumen amDef = AMDefinitionFactory.createFromRumenTrace(job, baselineTimeMS, this.slsRunner);
                    this.startAMs(amDef);
                }
                catch (Exception e) {
                    LOG.error("Failed to create an AM", (Throwable)e);
                }
                job = (LoggedJob)reader.getNext();
            }
        }
    }

    private void startAMs(AMDefinition amDef) {
        for (int i = 0; i < amDef.getJobCount(); ++i) {
            JobDefinition jobDef = JobDefinition.Builder.create().withAmDefinition(amDef).withDeadline(-1L).withReservationId(null).withParams(null).build();
            this.runNewAM(jobDef);
        }
    }

    private void startAMs(AMDefinition amDef, ReservationId reservationId, Map<String, String> params, long deadline) {
        for (int i = 0; i < amDef.getJobCount(); ++i) {
            JobDefinition jobDef = JobDefinition.Builder.create().withAmDefinition(amDef).withReservationId(reservationId).withParams(params).withDeadline(deadline).build();
            this.runNewAM(jobDef);
        }
    }

    private void runNewAM(JobDefinition jobDef) {
        AMDefinition amDef = jobDef.getAmDefinition();
        String oldJobId = amDef.getOldAppId();
        AMSimulator amSim = this.createAmSimulator(amDef.getAmType());
        if (amSim != null) {
            int heartbeatInterval = this.conf.getInt("yarn.sls.am.heartbeat.interval.ms", 1000);
            boolean isTracked = this.trackedApps.contains(oldJobId);
            if (oldJobId == null) {
                oldJobId = Integer.toString(this.AM_ID);
            }
            ++this.AM_ID;
            amSim.init(amDef, this.rm, this.slsRunner, isTracked, this.runner.getStartTimeMS(), heartbeatInterval, this.appIdAMSim);
            if (jobDef.getReservationId() != null) {
                UTCClock clock = new UTCClock();
                amSim.initReservation(jobDef.getReservationId(), jobDef.getDeadline(), clock.getTime());
            }
            this.runner.schedule(amSim);
            this.maxRuntime = Math.max(this.maxRuntime, amDef.getJobFinishTime());
            this.numTasks += amDef.getTaskContainers().size();
            this.amMap.put(oldJobId, amSim);
        }
    }

    private AMSimulator createAmSimulator(String jobType) {
        return (AMSimulator)ReflectionUtils.newInstance((Class)this.amClassMap.get(jobType), (Configuration)new Configuration());
    }

    public AMSimulator getAMSimulator(ApplicationId appId) {
        return this.appIdAMSim.get(appId);
    }

    public void setInputType(SLSRunner.TraceType inputType) {
        this.inputType = inputType;
    }

    public void setInputTraces(String[] inputTraces) {
        this.inputTraces = (String[])inputTraces.clone();
    }

    public void setResourceManager(ResourceManager rm) {
        this.rm = rm;
    }

    public Set<String> getTrackedApps() {
        return this.trackedApps;
    }

    public void setTrackedApps(Set<String> trackApps) {
        this.trackedApps = trackApps;
    }

    public int getNumAMs() {
        return this.numAMs;
    }

    public int getNumTasks() {
        return this.numTasks;
    }

    public long getMaxRuntime() {
        return this.maxRuntime;
    }

    public Map<String, AMSimulator> getAmMap() {
        return this.amMap;
    }
}

