/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class EncodingState {
    protected Cell prevCell = null;
    protected int unencodedDataSizeWritten = 0;
    protected int encodedDataSizeWritten = 0;

    public void beforeShipped() {
        if (this.prevCell != null) {
            this.prevCell = KeyValueUtil.copyToNewKeyValue(this.prevCell);
        }
    }

    public void postCellEncode(int unencodedCellSizeWritten, int encodedCellSizeWritten) {
        this.unencodedDataSizeWritten += unencodedCellSizeWritten;
        this.encodedDataSizeWritten += encodedCellSizeWritten;
    }

    public int getUnencodedDataSizeWritten() {
        return this.unencodedDataSizeWritten;
    }

    public int getEncodedDataSizeWritten() {
        return this.encodedDataSizeWritten;
    }
}

