/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.scheduler;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.sls.TaskContainerDefinition;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ContainerSimulator
implements Delayed {
    private ContainerId id;
    private Resource resource;
    private long endTime;
    private long lifeTime;
    private long requestDelay;
    private String hostname;
    private int priority;
    private String type;
    private ExecutionType executionType = ExecutionType.GUARANTEED;
    private long allocationId;

    public static ContainerSimulator createFromTaskContainerDefinition(TaskContainerDefinition def) {
        return new ContainerSimulator(def.getResource(), def.getDuration(), def.getHostname(), def.getPriority(), def.getType(), def.getExecutionType(), def.getAllocationId(), def.getRequestDelay());
    }

    private ContainerSimulator(Resource resource, long lifeTime, String hostname, int priority, String type, ExecutionType executionType, long allocationId, long requestDelay) {
        this.resource = resource;
        this.lifeTime = lifeTime;
        this.hostname = hostname;
        this.priority = priority;
        this.type = type;
        this.executionType = executionType;
        this.requestDelay = requestDelay;
        this.allocationId = allocationId;
    }

    public ContainerSimulator(ContainerId id, Resource resource, long endTime, long lifeTime, long allocationId) {
        this.id = id;
        this.resource = resource;
        this.endTime = endTime;
        this.lifeTime = lifeTime;
        this.allocationId = allocationId;
    }

    public Resource getResource() {
        return this.resource;
    }

    public ContainerId getId() {
        return this.id;
    }

    @Override
    public int compareTo(Delayed o) {
        if (!(o instanceof ContainerSimulator)) {
            throw new IllegalArgumentException("Parameter must be a ContainerSimulator instance");
        }
        ContainerSimulator other = (ContainerSimulator)o;
        return (int)Math.signum(this.endTime - other.endTime);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.endTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public long getLifeTime() {
        return this.lifeTime;
    }

    public String getHostname() {
        return this.hostname;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getType() {
        return this.type;
    }

    public void setPriority(int p) {
        this.priority = p;
    }

    public ExecutionType getExecutionType() {
        return this.executionType;
    }

    public long getAllocationId() {
        return this.allocationId;
    }

    public long getRequestDelay() {
        return this.requestDelay;
    }
}

