/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.driver;

import java.util.Collections;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class StateStoreOperationResult {
    private final List<String> failedRecordsKeys;
    private final boolean isOperationSuccessful;
    private static final StateStoreOperationResult DEFAULT_OPERATION_SUCCESS_RESULT = new StateStoreOperationResult(Collections.emptyList(), true);

    public StateStoreOperationResult(List<String> failedRecordsKeys, boolean isOperationSuccessful) {
        this.failedRecordsKeys = failedRecordsKeys;
        this.isOperationSuccessful = isOperationSuccessful;
    }

    public StateStoreOperationResult(String failedRecordKey) {
        if (failedRecordKey != null && failedRecordKey.length() > 0) {
            this.isOperationSuccessful = false;
            this.failedRecordsKeys = Collections.singletonList(failedRecordKey);
        } else {
            this.isOperationSuccessful = true;
            this.failedRecordsKeys = Collections.emptyList();
        }
    }

    public List<String> getFailedRecordsKeys() {
        return this.failedRecordsKeys;
    }

    public boolean isOperationSuccessful() {
        return this.isOperationSuccessful;
    }

    public static StateStoreOperationResult getDefaultSuccessResult() {
        return DEFAULT_OPERATION_SUCCESS_RESULT;
    }
}

