/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.config.builders;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.shaded.org.ehcache.config.Builder;
import org.apache.hadoop.shaded.org.ehcache.config.ResourcePool;
import org.apache.hadoop.shaded.org.ehcache.config.ResourcePools;
import org.apache.hadoop.shaded.org.ehcache.config.ResourceType;
import org.apache.hadoop.shaded.org.ehcache.config.ResourceUnit;
import org.apache.hadoop.shaded.org.ehcache.config.SizedResourcePool;
import org.apache.hadoop.shaded.org.ehcache.config.units.EntryUnit;
import org.apache.hadoop.shaded.org.ehcache.config.units.MemoryUnit;
import org.apache.hadoop.shaded.org.ehcache.impl.config.ResourcePoolsImpl;
import org.apache.hadoop.shaded.org.ehcache.impl.config.SizedResourcePoolImpl;

public class ResourcePoolsBuilder
implements Builder<ResourcePools> {
    private final Map<ResourceType<?>, ResourcePool> resourcePools;

    private ResourcePoolsBuilder() {
        this(Collections.emptyMap());
    }

    private ResourcePoolsBuilder(Map<ResourceType<?>, ResourcePool> resourcePools) {
        ResourcePoolsImpl.validateResourcePools(resourcePools.values());
        this.resourcePools = Collections.unmodifiableMap(resourcePools);
    }

    public static ResourcePoolsBuilder newResourcePoolsBuilder() {
        return new ResourcePoolsBuilder();
    }

    public static ResourcePoolsBuilder newResourcePoolsBuilder(ResourcePools pools) {
        ResourcePoolsBuilder poolsBuilder = new ResourcePoolsBuilder();
        for (ResourceType<?> currentResourceType : pools.getResourceTypeSet()) {
            poolsBuilder = poolsBuilder.with((ResourcePool)pools.getPoolForResource(currentResourceType));
        }
        return poolsBuilder;
    }

    public static ResourcePoolsBuilder heap(long entries) {
        return ResourcePoolsBuilder.newResourcePoolsBuilder().heap(entries, EntryUnit.ENTRIES);
    }

    public ResourcePoolsBuilder with(ResourcePool resourcePool) {
        ResourceType<?> type = resourcePool.getType();
        ResourcePool existingPool = this.resourcePools.get(type);
        if (existingPool != null) {
            throw new IllegalArgumentException("Can not add '" + resourcePool + "'; configuration already contains '" + existingPool + "'");
        }
        HashMap newPools = new HashMap(this.resourcePools);
        newPools.put(type, resourcePool);
        return new ResourcePoolsBuilder(newPools);
    }

    public ResourcePoolsBuilder withReplacing(ResourcePool resourcePool) {
        HashMap newPools = new HashMap(this.resourcePools);
        newPools.put(resourcePool.getType(), resourcePool);
        return new ResourcePoolsBuilder(newPools);
    }

    public ResourcePoolsBuilder with(ResourceType<SizedResourcePool> type, long size, ResourceUnit unit, boolean persistent) {
        return this.with(new SizedResourcePoolImpl<SizedResourcePool>(type, size, unit, persistent));
    }

    public ResourcePoolsBuilder heap(long size, ResourceUnit unit) {
        return this.with(ResourceType.Core.HEAP, size, unit, false);
    }

    public ResourcePoolsBuilder offheap(long size, MemoryUnit unit) {
        return this.with(ResourceType.Core.OFFHEAP, size, unit, false);
    }

    public ResourcePoolsBuilder disk(long size, MemoryUnit unit) {
        return this.disk(size, unit, false);
    }

    public ResourcePoolsBuilder disk(long size, MemoryUnit unit, boolean persistent) {
        return this.with(ResourceType.Core.DISK, size, unit, persistent);
    }

    @Override
    public ResourcePools build() {
        return new ResourcePoolsImpl(this.resourcePools);
    }
}

