/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.ssl;

import java.io.IOException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import org.apache.hadoop.shaded.org.glassfish.grizzly.CompletionHandler;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Connection;
import org.apache.hadoop.shaded.org.glassfish.grizzly.impl.FutureImpl;
import org.apache.hadoop.shaded.org.glassfish.grizzly.impl.SafeFutureImpl;
import org.apache.hadoop.shaded.org.glassfish.grizzly.memory.Buffers;
import org.apache.hadoop.shaded.org.glassfish.grizzly.ssl.SSLEncoderTransformer;
import org.apache.hadoop.shaded.org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.apache.hadoop.shaded.org.glassfish.grizzly.ssl.SSLStreamReader;
import org.apache.hadoop.shaded.org.glassfish.grizzly.ssl.SSLUtils;
import org.apache.hadoop.shaded.org.glassfish.grizzly.streams.StreamReader;
import org.apache.hadoop.shaded.org.glassfish.grizzly.streams.StreamWriter;
import org.apache.hadoop.shaded.org.glassfish.grizzly.streams.TransformerStreamWriter;
import org.apache.hadoop.shaded.org.glassfish.grizzly.utils.CompletionHandlerAdapter;
import org.apache.hadoop.shaded.org.glassfish.grizzly.utils.conditions.Condition;

public class SSLStreamWriter
extends TransformerStreamWriter {
    public SSLStreamWriter(StreamWriter underlyingWriter) {
        super(underlyingWriter, new SSLEncoderTransformer());
    }

    public Future<SSLEngine> handshake(SSLStreamReader sslStreamReader, SSLEngineConfigurator configurator) throws IOException {
        return this.handshake(sslStreamReader, configurator, null);
    }

    public Future<SSLEngine> handshake(SSLStreamReader sslStreamReader, SSLEngineConfigurator configurator, CompletionHandler<SSLEngine> completionHandler) throws IOException {
        SSLEngineResult.HandshakeStatus handshakeStatus;
        boolean isLoggingFinest;
        Connection connection = this.getConnection();
        SSLEngine sslEngine = SSLUtils.getSSLEngine(this.getConnection());
        if (sslEngine == null) {
            sslEngine = configurator.createSSLEngine();
            SSLUtils.setSSLEngine(connection, sslEngine);
            SSLStreamWriter.checkBuffers(connection, sslEngine);
        }
        if (isLoggingFinest = logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "connection={0} engine={1} handshakeStatus={2}", new Object[]{connection, sslEngine, sslEngine.getHandshakeStatus()});
        }
        if ((handshakeStatus = sslEngine.getHandshakeStatus()) == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            sslEngine.beginHandshake();
        }
        SafeFutureImpl<SSLEngine> future = SafeFutureImpl.create();
        HandshakeCompletionHandler hsCompletionHandler = new HandshakeCompletionHandler(future, completionHandler, sslEngine);
        sslStreamReader.notifyCondition(new SSLHandshakeCondition(sslStreamReader, this, configurator, sslEngine, hsCompletionHandler), hsCompletionHandler);
        return future;
    }

    private static void checkBuffers(Connection connection, SSLEngine sslEngine) {
        int packetBufferSize = sslEngine.getSession().getPacketBufferSize();
        if (connection.getReadBufferSize() < packetBufferSize) {
            connection.setReadBufferSize(packetBufferSize);
        }
        if (connection.getWriteBufferSize() < packetBufferSize) {
            connection.setWriteBufferSize(packetBufferSize);
        }
    }

    protected static final class HandshakeCompletionHandler
    extends CompletionHandlerAdapter<SSLEngine, Integer> {
        final SSLEngine sslEngine;

        public HandshakeCompletionHandler(FutureImpl<SSLEngine> future, CompletionHandler<SSLEngine> completionHandler, SSLEngine sslEngine) {
            super(future, completionHandler);
            this.sslEngine = sslEngine;
        }

        @Override
        protected SSLEngine adapt(Integer result) {
            return this.sslEngine;
        }
    }

    protected static class SSLHandshakeCondition
    implements Condition {
        private final SSLEngineConfigurator configurator;
        private final Connection connection;
        private final SSLEngine sslEngine;
        private final StreamReader streamReader;
        private final StreamWriter streamWriter;
        private final HandshakeCompletionHandler completionHandler;

        public SSLHandshakeCondition(StreamReader streamReader, StreamWriter streamWriter, SSLEngineConfigurator configurator, SSLEngine sslEngine, HandshakeCompletionHandler completionHandler) {
            this.connection = streamReader.getConnection();
            this.configurator = configurator;
            this.sslEngine = sslEngine;
            this.completionHandler = completionHandler;
            this.streamReader = streamReader;
            this.streamWriter = streamWriter;
        }

        @Override
        public boolean check() {
            try {
                return this.doHandshakeStep();
            }
            catch (IOException e) {
                this.completionHandler.failed(e);
                throw new RuntimeException("Unexpected handshake exception");
            }
        }

        public boolean doHandshakeStep() throws IOException {
            boolean isLoggingFinest = logger.isLoggable(Level.FINEST);
            SSLEngineResult.HandshakeStatus handshakeStatus = this.sslEngine.getHandshakeStatus();
            if (handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED || handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                return true;
            }
            do {
                if (isLoggingFinest) {
                    logger.log(Level.FINEST, "Loop Engine: {0} handshakeStatus={1}", new Object[]{this.sslEngine, this.sslEngine.getHandshakeStatus()});
                }
                switch (handshakeStatus) {
                    case NEED_UNWRAP: {
                        if (isLoggingFinest) {
                            logger.log(Level.FINEST, "NEED_UNWRAP Engine: {0}", this.sslEngine);
                        }
                        return false;
                    }
                    case NEED_WRAP: {
                        if (isLoggingFinest) {
                            logger.log(Level.FINEST, "NEED_WRAP Engine: {0}", this.sslEngine);
                        }
                        this.streamWriter.writeBuffer(Buffers.EMPTY_BUFFER);
                        this.streamWriter.flush();
                        handshakeStatus = this.sslEngine.getHandshakeStatus();
                        break;
                    }
                    case NEED_TASK: {
                        if (isLoggingFinest) {
                            logger.log(Level.FINEST, "NEED_TASK Engine: {0}", this.sslEngine);
                        }
                        SSLUtils.executeDelegatedTask(this.sslEngine);
                        handshakeStatus = this.sslEngine.getHandshakeStatus();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Invalid Handshaking State" + (Object)((Object)handshakeStatus));
                    }
                }
            } while (handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED);
            return true;
        }
    }
}

