/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.clientrm;

import java.io.IOException;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationSubmissionContextPBImpl;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.router.RouterAuditLogger;
import org.apache.hadoop.yarn.server.router.RouterMetrics;
import org.apache.hadoop.yarn.server.router.RouterServerUtil;
import org.apache.hadoop.yarn.server.router.clientrm.PassThroughClientRequestInterceptor;

public class ApplicationSubmissionContextInterceptor
extends PassThroughClientRequestInterceptor {
    @Override
    public SubmitApplicationResponse submitApplication(SubmitApplicationRequest request) throws YarnException, IOException {
        if (request == null || request.getApplicationSubmissionContext() == null || request.getApplicationSubmissionContext().getApplicationId() == null) {
            RouterMetrics.getMetrics().incrAppsFailedSubmitted();
            String errMsg = "Missing submitApplication request or applicationSubmissionContext information.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Submit New App", "UNKNOWN", "RouterClientRMService", errMsg);
            RouterServerUtil.logAndThrowException(errMsg, null);
        }
        ApplicationSubmissionContext appContext = request.getApplicationSubmissionContext();
        ApplicationSubmissionContextPBImpl asc = (ApplicationSubmissionContextPBImpl)appContext;
        RouterServerUtil.checkAppSubmissionContext(asc, this.getConf());
        return this.getNextInterceptor().submitApplication(request);
    }
}

