/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.rmadmin;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.api.ResourceManagerAdministrationProtocol;
import org.apache.hadoop.yarn.server.api.protocolrecords.AddToClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.AddToClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.BatchSaveFederationQueuePoliciesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.BatchSaveFederationQueuePoliciesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.CheckForDecommissioningNodesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.CheckForDecommissioningNodesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.DeleteFederationApplicationRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.DeleteFederationApplicationResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.DeleteFederationQueuePoliciesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.DeleteFederationQueuePoliciesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.DeregisterSubClusterRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.DeregisterSubClusterResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.DeregisterSubClusters;
import org.apache.hadoop.yarn.server.api.protocolrecords.FederationQueueWeight;
import org.apache.hadoop.yarn.server.api.protocolrecords.FederationSubCluster;
import org.apache.hadoop.yarn.server.api.protocolrecords.GetSubClustersRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.GetSubClustersResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodesToAttributesMappingRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodesToAttributesMappingResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.QueryFederationQueuePoliciesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.QueryFederationQueuePoliciesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshAdminAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshAdminAclsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshClusterMaxPriorityRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshClusterMaxPriorityResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesResourcesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesResourcesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshQueuesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshQueuesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshServiceAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshServiceAclsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshSuperUserGroupsConfigurationRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshSuperUserGroupsConfigurationResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshUserToGroupsMappingsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshUserToGroupsMappingsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoveFromClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoveFromClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReplaceLabelsOnNodeRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReplaceLabelsOnNodeResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.SaveFederationQueuePolicyRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.SaveFederationQueuePolicyResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.UpdateNodeResourceRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.UpdateNodeResourceResponse;
import org.apache.hadoop.yarn.server.federation.failover.FederationProxyProviderUtil;
import org.apache.hadoop.yarn.server.federation.policies.dao.WeightedPolicyInfo;
import org.apache.hadoop.yarn.server.federation.policies.manager.PriorityBroadcastPolicyManager;
import org.apache.hadoop.yarn.server.federation.policies.manager.WeightedHomePolicyManager;
import org.apache.hadoop.yarn.server.federation.policies.manager.WeightedLocalityPolicyManager;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.apache.hadoop.yarn.server.router.RouterMetrics;
import org.apache.hadoop.yarn.server.router.RouterServerUtil;
import org.apache.hadoop.yarn.server.router.rmadmin.AbstractRMAdminRequestInterceptor;
import org.apache.hadoop.yarn.server.router.rmadmin.RMAdminProtocolMethod;
import org.apache.hadoop.yarn.server.router.rmadmin.RMAdminRequestInterceptor;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.MonotonicClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederationRMAdminInterceptor
extends AbstractRMAdminRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(FederationRMAdminInterceptor.class);
    private static final String COMMA = ",";
    private static final String COLON = ":";
    private static final List<String> SUPPORT_WEIGHT_MANAGERS = new ArrayList<String>(Arrays.asList(WeightedLocalityPolicyManager.class.getName(), PriorityBroadcastPolicyManager.class.getName(), WeightedHomePolicyManager.class.getName()));
    private Map<SubClusterId, ResourceManagerAdministrationProtocol> adminRMProxies;
    private FederationStateStoreFacade federationFacade;
    private final Clock clock = new MonotonicClock();
    private RouterMetrics routerMetrics;
    private ThreadPoolExecutor executorService;
    private Configuration conf;
    private long heartbeatExpirationMillis;

    @Override
    public void init(String userName) {
        super.init(userName);
        int numThreads = this.getConf().getInt("yarn.router.interceptor.user.threadpool-size", 5);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("RPC Router RMAdminClient-" + userName + "-%d ").build();
        long keepAliveTime = this.getConf().getTimeDuration("yarn.router.interceptor.user-thread-pool.keep-alive-time", YarnConfiguration.DEFAULT_ROUTER_USER_CLIENT_THREAD_POOL_KEEP_ALIVE_TIME, TimeUnit.SECONDS);
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
        this.executorService = new ThreadPoolExecutor(numThreads, numThreads, keepAliveTime, TimeUnit.MILLISECONDS, workQueue, threadFactory);
        boolean allowCoreThreadTimeOut = this.getConf().getBoolean("yarn.router.interceptor.user-thread-pool.allow-core-thread-time-out", false);
        if (keepAliveTime > 0L && allowCoreThreadTimeOut) {
            this.executorService.allowCoreThreadTimeOut(allowCoreThreadTimeOut);
        }
        this.federationFacade = FederationStateStoreFacade.getInstance((Configuration)this.getConf());
        this.conf = this.getConf();
        this.adminRMProxies = new ConcurrentHashMap<SubClusterId, ResourceManagerAdministrationProtocol>();
        this.routerMetrics = RouterMetrics.getMetrics();
        this.heartbeatExpirationMillis = this.conf.getTimeDuration("yarn.router.subcluster.heartbeat.expiration.time", YarnConfiguration.DEFAULT_ROUTER_SUBCLUSTER_EXPIRATION_TIME, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    protected ResourceManagerAdministrationProtocol getAdminRMProxyForSubCluster(SubClusterId subClusterId) throws Exception {
        if (this.adminRMProxies.containsKey(subClusterId)) {
            return this.adminRMProxies.get(subClusterId);
        }
        ResourceManagerAdministrationProtocol adminRMProxy = null;
        try {
            boolean serviceAuthEnabled = this.conf.getBoolean("hadoop.security.authorization", false);
            UserGroupInformation realUser = this.user;
            if (serviceAuthEnabled) {
                realUser = UserGroupInformation.createProxyUser((String)this.user.getShortUserName(), (UserGroupInformation)UserGroupInformation.getLoginUser());
            }
            adminRMProxy = (ResourceManagerAdministrationProtocol)FederationProxyProviderUtil.createRMProxy((Configuration)this.getConf(), ResourceManagerAdministrationProtocol.class, (SubClusterId)subClusterId, (UserGroupInformation)realUser);
        }
        catch (Exception e) {
            RouterServerUtil.logAndThrowException(e, "Unable to create the interface to reach the SubCluster %s", subClusterId);
        }
        this.adminRMProxies.put(subClusterId, adminRMProxy);
        return adminRMProxy;
    }

    @Override
    public void setNextInterceptor(RMAdminRequestInterceptor next) {
        throw new YarnRuntimeException("setNextInterceptor is being called on FederationRMAdminRequestInterceptor, which should be the last one in the chain. Check if the interceptor pipeline configuration is correct");
    }

    public RefreshQueuesResponse refreshQueues(RefreshQueuesRequest request) throws StandbyException, YarnException, IOException {
        if (request == null) {
            this.routerMetrics.incrRefreshQueuesFailedRetrieved();
            RouterServerUtil.logAndThrowException("Missing RefreshQueues request.", null);
        }
        try {
            long startTime = this.clock.getTime();
            RMAdminProtocolMethod remoteMethod = new RMAdminProtocolMethod(new Class[]{RefreshQueuesRequest.class}, request);
            String subClusterId = request.getSubClusterId();
            Collection<RefreshQueuesResponse> refreshQueueResps = remoteMethod.invokeConcurrent(this, RefreshQueuesResponse.class, subClusterId);
            if (CollectionUtils.isNotEmpty(refreshQueueResps)) {
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededRefreshQueuesRetrieved(stopTime - startTime);
                return RefreshQueuesResponse.newInstance();
            }
        }
        catch (YarnException e) {
            this.routerMetrics.incrRefreshQueuesFailedRetrieved();
            RouterServerUtil.logAndThrowException(e, "Unable to refreshQueue due to exception. " + e.getMessage(), new Object[0]);
        }
        this.routerMetrics.incrRefreshQueuesFailedRetrieved();
        throw new YarnException("Unable to refreshQueue.");
    }

    public RefreshNodesResponse refreshNodes(RefreshNodesRequest request) throws StandbyException, YarnException, IOException {
        if (request == null) {
            this.routerMetrics.incrRefreshNodesFailedRetrieved();
            RouterServerUtil.logAndThrowException("Missing RefreshNodes request.", null);
        }
        try {
            long startTime = this.clock.getTime();
            RMAdminProtocolMethod remoteMethod = new RMAdminProtocolMethod(new Class[]{RefreshNodesRequest.class}, request);
            String subClusterId = request.getSubClusterId();
            Collection<RefreshNodesResponse> refreshNodesResps = remoteMethod.invokeConcurrent(this, RefreshNodesResponse.class, subClusterId);
            if (CollectionUtils.isNotEmpty(refreshNodesResps)) {
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededRefreshNodesRetrieved(stopTime - startTime);
                return RefreshNodesResponse.newInstance();
            }
        }
        catch (YarnException e) {
            this.routerMetrics.incrRefreshNodesFailedRetrieved();
            RouterServerUtil.logAndThrowException(e, "Unable to refreshNodes due to exception. " + e.getMessage(), new Object[0]);
        }
        this.routerMetrics.incrRefreshNodesFailedRetrieved();
        throw new YarnException("Unable to refreshNodes due to exception.");
    }

    public RefreshSuperUserGroupsConfigurationResponse refreshSuperUserGroupsConfiguration(RefreshSuperUserGroupsConfigurationRequest request) throws StandbyException, YarnException, IOException {
        if (request == null) {
            this.routerMetrics.incrRefreshSuperUserGroupsConfigurationFailedRetrieved();
            RouterServerUtil.logAndThrowException("Missing RefreshSuperUserGroupsConfiguration request.", null);
        }
        try {
            long startTime = this.clock.getTime();
            RMAdminProtocolMethod remoteMethod = new RMAdminProtocolMethod(new Class[]{RefreshSuperUserGroupsConfigurationRequest.class}, request);
            String subClusterId = request.getSubClusterId();
            Collection<RefreshSuperUserGroupsConfigurationResponse> refreshSuperUserGroupsConfResps = remoteMethod.invokeConcurrent(this, RefreshSuperUserGroupsConfigurationResponse.class, subClusterId);
            if (CollectionUtils.isNotEmpty(refreshSuperUserGroupsConfResps)) {
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededRefreshSuperUserGroupsConfRetrieved(stopTime - startTime);
                return RefreshSuperUserGroupsConfigurationResponse.newInstance();
            }
        }
        catch (YarnException e) {
            this.routerMetrics.incrRefreshSuperUserGroupsConfigurationFailedRetrieved();
            RouterServerUtil.logAndThrowException(e, "Unable to refreshSuperUserGroupsConfiguration due to exception. " + e.getMessage(), new Object[0]);
        }
        this.routerMetrics.incrRefreshSuperUserGroupsConfigurationFailedRetrieved();
        throw new YarnException("Unable to refreshSuperUserGroupsConfiguration.");
    }

    public RefreshUserToGroupsMappingsResponse refreshUserToGroupsMappings(RefreshUserToGroupsMappingsRequest request) throws StandbyException, YarnException, IOException {
        if (request == null) {
            this.routerMetrics.incrRefreshUserToGroupsMappingsFailedRetrieved();
            RouterServerUtil.logAndThrowException("Missing RefreshUserToGroupsMappings request.", null);
        }
        try {
            long startTime = this.clock.getTime();
            RMAdminProtocolMethod remoteMethod = new RMAdminProtocolMethod(new Class[]{RefreshUserToGroupsMappingsRequest.class}, request);
            String subClusterId = request.getSubClusterId();
            Collection<RefreshUserToGroupsMappingsResponse> refreshUserToGroupsMappingsResps = remoteMethod.invokeConcurrent(this, RefreshUserToGroupsMappingsResponse.class, subClusterId);
            if (CollectionUtils.isNotEmpty(refreshUserToGroupsMappingsResps)) {
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededRefreshUserToGroupsMappingsRetrieved(stopTime - startTime);
                return RefreshUserToGroupsMappingsResponse.newInstance();
            }
        }
        catch (YarnException e) {
            this.routerMetrics.incrRefreshUserToGroupsMappingsFailedRetrieved();
            RouterServerUtil.logAndThrowException(e, "Unable to refreshUserToGroupsMappings due to exception. " + e.getMessage(), new Object[0]);
        }
        this.routerMetrics.incrRefreshUserToGroupsMappingsFailedRetrieved();
        throw new YarnException("Unable to refreshUserToGroupsMappings.");
    }

    public RefreshAdminAclsResponse refreshAdminAcls(RefreshAdminAclsRequest request) throws YarnException, IOException {
        if (request == null) {
            this.routerMetrics.incrRefreshAdminAclsFailedRetrieved();
            RouterServerUtil.logAndThrowException("Missing RefreshAdminAcls request.", null);
        }
        try {
            long startTime = this.clock.getTime();
            RMAdminProtocolMethod remoteMethod = new RMAdminProtocolMethod(new Class[]{RefreshAdminAclsRequest.class}, request);
            String subClusterId = request.getSubClusterId();
            Collection<RefreshAdminAclsResponse> refreshAdminAclsResps = remoteMethod.invokeConcurrent(this, RefreshAdminAclsResponse.class, subClusterId);
            if (CollectionUtils.isNotEmpty(refreshAdminAclsResps)) {
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededRefreshAdminAclsRetrieved(stopTime - startTime);
                return RefreshAdminAclsResponse.newInstance();
            }
        }
        catch (YarnException e) {
            this.routerMetrics.incrRefreshAdminAclsFailedRetrieved();
            RouterServerUtil.logAndThrowException(e, "Unable to refreshAdminAcls due to exception. " + e.getMessage(), new Object[0]);
        }
        this.routerMetrics.incrRefreshAdminAclsFailedRetrieved();
        throw new YarnException("Unable to refreshAdminAcls.");
    }

    public RefreshServiceAclsResponse refreshServiceAcls(RefreshServiceAclsRequest request) throws YarnException, IOException {
        if (request == null) {
            this.routerMetrics.incrRefreshServiceAclsFailedRetrieved();
            RouterServerUtil.logAndThrowException("Missing RefreshServiceAcls request.", null);
        }
        try {
            long startTime = this.clock.getTime();
            RMAdminProtocolMethod remoteMethod = new RMAdminProtocolMethod(new Class[]{RefreshServiceAclsRequest.class}, request);
            String subClusterId = request.getSubClusterId();
            Collection<RefreshServiceAclsResponse> refreshServiceAclsResps = remoteMethod.invokeConcurrent(this, RefreshServiceAclsResponse.class, subClusterId);
            if (CollectionUtils.isNotEmpty(refreshServiceAclsResps)) {
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededRefreshServiceAclsRetrieved(stopTime - startTime);
                return RefreshServiceAclsResponse.newInstance();
            }
        }
        catch (YarnException e) {
            this.routerMetrics.incrRefreshServiceAclsFailedRetrieved();
            RouterServerUtil.logAndThrowException(e, "Unable to refreshAdminAcls due to exception. " + e.getMessage(), new Object[0]);
        }
        this.routerMetrics.incrRefreshServiceAclsFailedRetrieved();
        throw new YarnException("Unable to refreshServiceAcls.");
    }

    public UpdateNodeResourceResponse updateNodeResource(UpdateNodeResourceRequest request) throws YarnException, IOException {
        String subClusterId;
        if (request == null) {
            this.routerMetrics.incrUpdateNodeResourceFailedRetrieved();
            RouterServerUtil.logAndThrowException("Missing UpdateNodeResource request.", null);
        }
        if (StringUtils.isBlank((CharSequence)(subClusterId = request.getSubClusterId()))) {
            this.routerMetrics.incrUpdateNodeResourceFailedRetrieved();
            RouterServerUtil.logAndThrowException("Missing UpdateNodeResource SubClusterId.", null);
        }
        try {
            long startTime = this.clock.getTime();
            RMAdminProtocolMethod remoteMethod = new RMAdminProtocolMethod(new Class[]{UpdateNodeResourceRequest.class}, request);
            Collection<UpdateNodeResourceResponse> updateNodeResourceResps = remoteMethod.invokeConcurrent(this, UpdateNodeResourceResponse.class, subClusterId);
            if (CollectionUtils.isNotEmpty(updateNodeResourceResps)) {
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededUpdateNodeResourceRetrieved(stopTime - startTime);
                return UpdateNodeResourceResponse.newInstance();
            }
        }
        catch (YarnException e) {
            this.routerMetrics.incrUpdateNodeResourceFailedRetrieved();
            RouterServerUtil.logAndThrowException(e, "Unable to updateNodeResource due to exception. " + e.getMessage(), new Object[0]);
        }
        this.routerMetrics.incrUpdateNodeResourceFailedRetrieved();
        throw new YarnException("Unable to updateNodeResource.");
    }

    public RefreshNodesResourcesResponse refreshNodesResources(RefreshNodesResourcesRequest request) throws YarnException, IOException {
        String subClusterId;
        if (request == null) {
            this.routerMetrics.incrRefreshNodesResourcesFailedRetrieved();
            RouterServerUtil.logAndThrowException("Missing RefreshNodesResources request.", null);
        }
        if (StringUtils.isBlank((CharSequence)(subClusterId = request.getSubClusterId()))) {
            this.routerMetrics.incrRefreshNodesResourcesFailedRetrieved();
            RouterServerUtil.logAndThrowException("Missing RefreshNodesResources SubClusterId.", null);
        }
        try {
            long startTime = this.clock.getTime();
            RMAdminProtocolMethod remoteMethod = new RMAdminProtocolMethod(new Class[]{RefreshNodesResourcesRequest.class}, request);
            Collection<RefreshNodesResourcesResponse> refreshNodesResourcesResps = remoteMethod.invokeConcurrent(this, RefreshNodesResourcesResponse.class, subClusterId);
            if (CollectionUtils.isNotEmpty(refreshNodesResourcesResps)) {
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededRefreshNodesResourcesRetrieved(stopTime - startTime);
                return RefreshNodesResourcesResponse.newInstance();
            }
        }
        catch (YarnException e) {
            this.routerMetrics.incrRefreshNodesResourcesFailedRetrieved();
            RouterServerUtil.logAndThrowException(e, "Unable to refreshNodesResources due to exception. " + e.getMessage(), new Object[0]);
        }
        this.routerMetrics.incrRefreshNodesResourcesFailedRetrieved();
        throw new YarnException("Unable to refreshNodesResources.");
    }

    public AddToClusterNodeLabelsResponse addToClusterNodeLabels(AddToClusterNodeLabelsRequest request) throws YarnException, IOException {
        String subClusterId;
        if (request == null) {
            this.routerMetrics.incrAddToClusterNodeLabelsFailedRetrieved();
            RouterServerUtil.logAndThrowException("Missing AddToClusterNodeLabels request.", null);
        }
        if (StringUtils.isBlank((CharSequence)(subClusterId = request.getSubClusterId()))) {
            this.routerMetrics.incrAddToClusterNodeLabelsFailedRetrieved();
            RouterServerUtil.logAndThrowException("Missing AddToClusterNodeLabels SubClusterId.", null);
        }
        try {
            long startTime = this.clock.getTime();
            RMAdminProtocolMethod remoteMethod = new RMAdminProtocolMethod(new Class[]{AddToClusterNodeLabelsRequest.class}, request);
            Collection<AddToClusterNodeLabelsResponse> addToClusterNodeLabelsResps = remoteMethod.invokeConcurrent(this, AddToClusterNodeLabelsResponse.class, subClusterId);
            if (CollectionUtils.isNotEmpty(addToClusterNodeLabelsResps)) {
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededAddToClusterNodeLabelsRetrieved(stopTime - startTime);
                return AddToClusterNodeLabelsResponse.newInstance();
            }
        }
        catch (YarnException e) {
            this.routerMetrics.incrAddToClusterNodeLabelsFailedRetrieved();
            RouterServerUtil.logAndThrowException(e, "Unable to addToClusterNodeLabels due to exception. " + e.getMessage(), new Object[0]);
        }
        this.routerMetrics.incrAddToClusterNodeLabelsFailedRetrieved();
        throw new YarnException("Unable to addToClusterNodeLabels.");
    }

    public RemoveFromClusterNodeLabelsResponse removeFromClusterNodeLabels(RemoveFromClusterNodeLabelsRequest request) throws YarnException, IOException {
        String subClusterId;
        if (request == null) {
            this.routerMetrics.incrRemoveFromClusterNodeLabelsFailedRetrieved();
            RouterServerUtil.logAndThrowException("Missing RemoveFromClusterNodeLabels request.", null);
        }
        if (StringUtils.isBlank((CharSequence)(subClusterId = request.getSubClusterId()))) {
            this.routerMetrics.incrRemoveFromClusterNodeLabelsFailedRetrieved();
            RouterServerUtil.logAndThrowException("Missing RemoveFromClusterNodeLabels SubClusterId.", null);
        }
        try {
            long startTime = this.clock.getTime();
            RMAdminProtocolMethod remoteMethod = new RMAdminProtocolMethod(new Class[]{RemoveFromClusterNodeLabelsRequest.class}, request);
            Collection<RemoveFromClusterNodeLabelsResponse> refreshNodesResourcesResps = remoteMethod.invokeConcurrent(this, RemoveFromClusterNodeLabelsResponse.class, subClusterId);
            if (CollectionUtils.isNotEmpty(refreshNodesResourcesResps)) {
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededRemoveFromClusterNodeLabelsRetrieved(stopTime - startTime);
                return RemoveFromClusterNodeLabelsResponse.newInstance();
            }
        }
        catch (YarnException e) {
            this.routerMetrics.incrRemoveFromClusterNodeLabelsFailedRetrieved();
            RouterServerUtil.logAndThrowException(e, "Unable to removeFromClusterNodeLabels due to exception. " + e.getMessage(), new Object[0]);
        }
        this.routerMetrics.incrRemoveFromClusterNodeLabelsFailedRetrieved();
        throw new YarnException("Unable to removeFromClusterNodeLabels.");
    }

    public ReplaceLabelsOnNodeResponse replaceLabelsOnNode(ReplaceLabelsOnNodeRequest request) throws YarnException, IOException {
        String subClusterId;
        if (request == null) {
            this.routerMetrics.incrReplaceLabelsOnNodeFailedRetrieved();
            RouterServerUtil.logAndThrowException("Missing ReplaceLabelsOnNode request.", null);
        }
        if (StringUtils.isBlank((CharSequence)(subClusterId = request.getSubClusterId()))) {
            this.routerMetrics.incrReplaceLabelsOnNodeFailedRetrieved();
            RouterServerUtil.logAndThrowException("Missing ReplaceLabelsOnNode SubClusterId.", null);
        }
        try {
            long startTime = this.clock.getTime();
            RMAdminProtocolMethod remoteMethod = new RMAdminProtocolMethod(new Class[]{ReplaceLabelsOnNodeRequest.class}, request);
            Collection<ReplaceLabelsOnNodeResponse> replaceLabelsOnNodeResps = remoteMethod.invokeConcurrent(this, ReplaceLabelsOnNodeResponse.class, subClusterId);
            if (CollectionUtils.isNotEmpty(replaceLabelsOnNodeResps)) {
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededRemoveFromClusterNodeLabelsRetrieved(stopTime - startTime);
                return ReplaceLabelsOnNodeResponse.newInstance();
            }
        }
        catch (YarnException e) {
            this.routerMetrics.incrReplaceLabelsOnNodeFailedRetrieved();
            RouterServerUtil.logAndThrowException(e, "Unable to replaceLabelsOnNode due to exception. " + e.getMessage(), new Object[0]);
        }
        this.routerMetrics.incrReplaceLabelsOnNodeFailedRetrieved();
        throw new YarnException("Unable to replaceLabelsOnNode.");
    }

    public CheckForDecommissioningNodesResponse checkForDecommissioningNodes(CheckForDecommissioningNodesRequest request) throws YarnException, IOException {
        String subClusterId;
        if (request == null) {
            RouterServerUtil.logAndThrowException("Missing checkForDecommissioningNodes request.", null);
            this.routerMetrics.incrCheckForDecommissioningNodesFailedRetrieved();
        }
        if (StringUtils.isBlank((CharSequence)(subClusterId = request.getSubClusterId()))) {
            this.routerMetrics.incrCheckForDecommissioningNodesFailedRetrieved();
            RouterServerUtil.logAndThrowException("Missing checkForDecommissioningNodes SubClusterId.", null);
        }
        try {
            List collects;
            long startTime = this.clock.getTime();
            RMAdminProtocolMethod remoteMethod = new RMAdminProtocolMethod(new Class[]{CheckForDecommissioningNodesRequest.class}, request);
            Collection<CheckForDecommissioningNodesResponse> responses = remoteMethod.invokeConcurrent(this, CheckForDecommissioningNodesResponse.class, subClusterId);
            if (CollectionUtils.isNotEmpty(responses) && !(collects = responses.stream().collect(Collectors.toList())).isEmpty() && collects.size() == 1) {
                CheckForDecommissioningNodesResponse response = (CheckForDecommissioningNodesResponse)collects.get(0);
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededCheckForDecommissioningNodesRetrieved(stopTime - startTime);
                Set nodes = response.getDecommissioningNodes();
                return CheckForDecommissioningNodesResponse.newInstance((Set)nodes);
            }
        }
        catch (YarnException e) {
            this.routerMetrics.incrCheckForDecommissioningNodesFailedRetrieved();
            RouterServerUtil.logAndThrowException(e, "Unable to checkForDecommissioningNodes due to exception " + e.getMessage(), new Object[0]);
        }
        this.routerMetrics.incrCheckForDecommissioningNodesFailedRetrieved();
        throw new YarnException("Unable to checkForDecommissioningNodes.");
    }

    public RefreshClusterMaxPriorityResponse refreshClusterMaxPriority(RefreshClusterMaxPriorityRequest request) throws YarnException, IOException {
        String subClusterId;
        if (request == null) {
            this.routerMetrics.incrRefreshClusterMaxPriorityFailedRetrieved();
            RouterServerUtil.logAndThrowException("Missing RefreshClusterMaxPriority request.", null);
        }
        if (StringUtils.isBlank((CharSequence)(subClusterId = request.getSubClusterId()))) {
            this.routerMetrics.incrRefreshClusterMaxPriorityFailedRetrieved();
            RouterServerUtil.logAndThrowException("Missing RefreshClusterMaxPriority SubClusterId.", null);
        }
        try {
            long startTime = this.clock.getTime();
            RMAdminProtocolMethod remoteMethod = new RMAdminProtocolMethod(new Class[]{RefreshClusterMaxPriorityRequest.class}, request);
            Collection<RefreshClusterMaxPriorityResponse> refreshClusterMaxPriorityResps = remoteMethod.invokeConcurrent(this, RefreshClusterMaxPriorityResponse.class, subClusterId);
            if (CollectionUtils.isNotEmpty(refreshClusterMaxPriorityResps)) {
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededRefreshClusterMaxPriorityRetrieved(stopTime - startTime);
                return RefreshClusterMaxPriorityResponse.newInstance();
            }
        }
        catch (YarnException e) {
            this.routerMetrics.incrRefreshClusterMaxPriorityFailedRetrieved();
            RouterServerUtil.logAndThrowException(e, "Unable to refreshClusterMaxPriority due to exception. " + e.getMessage(), new Object[0]);
        }
        this.routerMetrics.incrRefreshClusterMaxPriorityFailedRetrieved();
        throw new YarnException("Unable to refreshClusterMaxPriority.");
    }

    public NodesToAttributesMappingResponse mapAttributesToNodes(NodesToAttributesMappingRequest request) throws YarnException, IOException {
        String subClusterId;
        if (request == null) {
            this.routerMetrics.incrMapAttributesToNodesFailedRetrieved();
            RouterServerUtil.logAndThrowException("Missing mapAttributesToNodes request.", null);
        }
        if (StringUtils.isBlank((CharSequence)(subClusterId = request.getSubClusterId()))) {
            this.routerMetrics.incrMapAttributesToNodesFailedRetrieved();
            RouterServerUtil.logAndThrowException("Missing mapAttributesToNodes SubClusterId.", null);
        }
        try {
            long startTime = this.clock.getTime();
            RMAdminProtocolMethod remoteMethod = new RMAdminProtocolMethod(new Class[]{NodesToAttributesMappingRequest.class}, request);
            Collection<NodesToAttributesMappingResponse> mapAttributesToNodesResps = remoteMethod.invokeConcurrent(this, NodesToAttributesMappingResponse.class, subClusterId);
            if (CollectionUtils.isNotEmpty(mapAttributesToNodesResps)) {
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededMapAttributesToNodesRetrieved(stopTime - startTime);
                return NodesToAttributesMappingResponse.newInstance();
            }
        }
        catch (YarnException e) {
            this.routerMetrics.incrMapAttributesToNodesFailedRetrieved();
            RouterServerUtil.logAndThrowException(e, "Unable to mapAttributesToNodes due to exception. " + e.getMessage(), new Object[0]);
        }
        this.routerMetrics.incrMapAttributesToNodesFailedRetrieved();
        throw new YarnException("Unable to mapAttributesToNodes.");
    }

    public String[] getGroupsForUser(String user) throws IOException {
        if (StringUtils.isBlank((CharSequence)user)) {
            this.routerMetrics.incrGetGroupsForUserFailedRetrieved();
            RouterServerUtil.logAndThrowIOException("Missing getGroupsForUser user.", null);
        }
        try {
            long startTime = this.clock.getTime();
            RMAdminProtocolMethod remoteMethod = new RMAdminProtocolMethod(new Class[]{String.class}, user);
            Collection<String[]> getGroupsForUserResps = remoteMethod.invokeConcurrent(this, String[].class, null);
            if (CollectionUtils.isNotEmpty(getGroupsForUserResps)) {
                long stopTime = this.clock.getTime();
                HashSet<String> groups = new HashSet<String>();
                for (String[] groupArr : getGroupsForUserResps) {
                    if (groupArr == null || groupArr.length <= 0) continue;
                    for (String group : groupArr) {
                        groups.add(group);
                    }
                }
                this.routerMetrics.succeededGetGroupsForUsersRetrieved(stopTime - startTime);
                return groups.toArray(new String[0]);
            }
        }
        catch (YarnException e) {
            this.routerMetrics.incrGetGroupsForUserFailedRetrieved();
            RouterServerUtil.logAndThrowIOException(e, "Unable to getGroupsForUser due to exception. " + e.getMessage(), new Object[0]);
        }
        this.routerMetrics.incrGetGroupsForUserFailedRetrieved();
        throw new IOException("Unable to getGroupsForUser.");
    }

    @VisibleForTesting
    public FederationStateStoreFacade getFederationFacade() {
        return this.federationFacade;
    }

    @VisibleForTesting
    public ThreadPoolExecutor getExecutorService() {
        return this.executorService;
    }

    public DeregisterSubClusterResponse deregisterSubCluster(DeregisterSubClusterRequest request) throws YarnException, IOException {
        if (request == null) {
            this.routerMetrics.incrDeregisterSubClusterFailedRetrieved();
            RouterServerUtil.logAndThrowException("Missing DeregisterSubCluster request.", null);
        }
        try {
            long startTime = this.clock.getTime();
            ArrayList<DeregisterSubClusters> deregisterSubClusterList = new ArrayList<DeregisterSubClusters>();
            String reqSubClusterId = request.getSubClusterId();
            if (StringUtils.isNotBlank((CharSequence)reqSubClusterId)) {
                DeregisterSubClusters deregisterSubClusters = this.deregisterSubCluster(reqSubClusterId);
                deregisterSubClusterList.add(deregisterSubClusters);
            } else {
                Map subClusterInfo = this.federationFacade.getSubClusters(true);
                for (Map.Entry entry : subClusterInfo.entrySet()) {
                    SubClusterId subClusterId = (SubClusterId)entry.getKey();
                    DeregisterSubClusters deregisterSubClusters = this.deregisterSubCluster(subClusterId.getId());
                    deregisterSubClusterList.add(deregisterSubClusters);
                }
            }
            long stopTime = this.clock.getTime();
            this.routerMetrics.succeededDeregisterSubClusterRetrieved(stopTime - startTime);
            return DeregisterSubClusterResponse.newInstance(deregisterSubClusterList);
        }
        catch (Exception e) {
            this.routerMetrics.incrDeregisterSubClusterFailedRetrieved();
            RouterServerUtil.logAndThrowException(e, "Unable to deregisterSubCluster due to exception. " + e.getMessage(), new Object[0]);
            this.routerMetrics.incrDeregisterSubClusterFailedRetrieved();
            throw new YarnException("Unable to deregisterSubCluster.");
        }
    }

    public SaveFederationQueuePolicyResponse saveFederationQueuePolicy(SaveFederationQueuePolicyRequest request) throws YarnException, IOException {
        String policyManagerClassName;
        String queue;
        FederationQueueWeight federationQueueWeight;
        if (request == null) {
            this.routerMetrics.incrSaveFederationQueuePolicyFailedRetrieved();
            RouterServerUtil.logAndThrowException("Missing SaveFederationQueuePolicy request.", null);
        }
        if ((federationQueueWeight = request.getFederationQueueWeight()) == null) {
            this.routerMetrics.incrSaveFederationQueuePolicyFailedRetrieved();
            RouterServerUtil.logAndThrowException("Missing FederationQueueWeight information.", null);
        }
        if (StringUtils.isBlank((CharSequence)(queue = request.getQueue()))) {
            this.routerMetrics.incrSaveFederationQueuePolicyFailedRetrieved();
            RouterServerUtil.logAndThrowException("Missing Queue information.", null);
        }
        if (!RouterServerUtil.checkPolicyManagerValid(policyManagerClassName = request.getPolicyManagerClassName(), SUPPORT_WEIGHT_MANAGERS)) {
            this.routerMetrics.incrSaveFederationQueuePolicyFailedRetrieved();
            RouterServerUtil.logAndThrowException(policyManagerClassName + " does not support the use of queue weights.", null);
        }
        String amRmWeight = federationQueueWeight.getAmrmWeight();
        FederationQueueWeight.checkSubClusterQueueWeightRatioValid((String)amRmWeight);
        String routerWeight = federationQueueWeight.getRouterWeight();
        FederationQueueWeight.checkSubClusterQueueWeightRatioValid((String)routerWeight);
        String headRoomAlpha = federationQueueWeight.getHeadRoomAlpha();
        FederationQueueWeight.checkHeadRoomAlphaValid((String)headRoomAlpha);
        try {
            long startTime = this.clock.getTime();
            Map<SubClusterIdInfo, Float> amRMPolicyWeights = this.getSubClusterWeightMap(amRmWeight);
            LOG.debug("amRMPolicyWeights = {}.", amRMPolicyWeights);
            Map<SubClusterIdInfo, Float> routerPolicyWeights = this.getSubClusterWeightMap(routerWeight);
            LOG.debug("routerWeights = {}.", amRMPolicyWeights);
            WeightedPolicyInfo weightedPolicyInfo = new WeightedPolicyInfo();
            weightedPolicyInfo.setHeadroomAlpha(Float.parseFloat(headRoomAlpha));
            weightedPolicyInfo.setAMRMPolicyWeights(amRMPolicyWeights);
            weightedPolicyInfo.setRouterPolicyWeights(routerPolicyWeights);
            SubClusterPolicyConfiguration policyConfiguration = SubClusterPolicyConfiguration.newInstance((String)queue, (String)policyManagerClassName, (ByteBuffer)weightedPolicyInfo.toByteBuffer());
            this.federationFacade.setPolicyConfiguration(policyConfiguration);
            long stopTime = this.clock.getTime();
            this.routerMetrics.succeededSaveFederationQueuePolicyRetrieved(stopTime - startTime);
            return SaveFederationQueuePolicyResponse.newInstance((String)"save policy success.");
        }
        catch (Exception e) {
            this.routerMetrics.incrSaveFederationQueuePolicyFailedRetrieved();
            RouterServerUtil.logAndThrowException(e, "Unable to saveFederationQueuePolicy due to exception. " + e.getMessage(), new Object[0]);
            this.routerMetrics.incrSaveFederationQueuePolicyFailedRetrieved();
            throw new YarnException("Unable to saveFederationQueuePolicy.");
        }
    }

    public BatchSaveFederationQueuePoliciesResponse batchSaveFederationQueuePolicies(BatchSaveFederationQueuePoliciesRequest request) throws YarnException, IOException {
        List federationQueueWeights;
        if (request == null) {
            this.routerMetrics.incrBatchSaveFederationQueuePoliciesFailedRetrieved();
            RouterServerUtil.logAndThrowException("Missing BatchSaveFederationQueuePoliciesRequest request.", null);
        }
        if ((federationQueueWeights = request.getFederationQueueWeights()) == null) {
            this.routerMetrics.incrBatchSaveFederationQueuePoliciesFailedRetrieved();
            RouterServerUtil.logAndThrowException("Missing FederationQueueWeights information.", null);
        }
        try {
            long startTime = this.clock.getTime();
            for (FederationQueueWeight federationQueueWeight : federationQueueWeights) {
                this.saveFederationQueuePolicy(federationQueueWeight);
            }
            long stopTime = this.clock.getTime();
            this.routerMetrics.succeededBatchSaveFederationQueuePoliciesRetrieved(stopTime - startTime);
            return BatchSaveFederationQueuePoliciesResponse.newInstance((String)"batch save policies success.");
        }
        catch (Exception e) {
            this.routerMetrics.incrBatchSaveFederationQueuePoliciesFailedRetrieved();
            RouterServerUtil.logAndThrowException(e, "Unable to batchSaveFederationQueuePolicies due to exception. " + e.getMessage(), new Object[0]);
            this.routerMetrics.incrBatchSaveFederationQueuePoliciesFailedRetrieved();
            throw new YarnException("Unable to batchSaveFederationQueuePolicies.");
        }
    }

    public QueryFederationQueuePoliciesResponse listFederationQueuePolicies(QueryFederationQueuePoliciesRequest request) throws YarnException, IOException {
        if (request == null) {
            this.routerMetrics.incrListFederationQueuePoliciesFailedRetrieved();
            RouterServerUtil.logAndThrowException("Missing ListFederationQueuePolicies Request.", null);
        }
        if (request.getPageSize() <= 0) {
            this.routerMetrics.incrListFederationQueuePoliciesFailedRetrieved();
            RouterServerUtil.logAndThrowException("PageSize cannot be negative or zero.", null);
        }
        if (request.getCurrentPage() <= 0) {
            this.routerMetrics.incrListFederationQueuePoliciesFailedRetrieved();
            RouterServerUtil.logAndThrowException("CurrentPage cannot be negative or zero.", null);
        }
        try {
            long startTime = this.clock.getTime();
            String queue = request.getQueue();
            List queues = request.getQueues();
            int currentPage = request.getCurrentPage();
            int pageSize = request.getPageSize();
            LOG.info("queue = {}, queues={}, currentPage={}, pageSize={}", new Object[]{queue, queues, currentPage, pageSize});
            Map policiesConfigurations = this.federationFacade.getPoliciesConfigurations();
            QueryFederationQueuePoliciesResponse response = StringUtils.isNotBlank((CharSequence)queue) ? this.filterPoliciesConfigurationsByQueue(queue, policiesConfigurations, pageSize, currentPage) : (CollectionUtils.isNotEmpty((Collection)queues) ? this.filterPoliciesConfigurationsByQueues(queues, policiesConfigurations, pageSize, currentPage) : this.filterPoliciesConfigurations(policiesConfigurations, pageSize, currentPage));
            long stopTime = this.clock.getTime();
            this.routerMetrics.succeededListFederationQueuePoliciesRetrieved(stopTime - startTime);
            if (response == null) {
                response = QueryFederationQueuePoliciesResponse.newInstance();
            }
            return response;
        }
        catch (Exception e) {
            this.routerMetrics.incrListFederationQueuePoliciesFailedRetrieved();
            RouterServerUtil.logAndThrowException(e, "Unable to ListFederationQueuePolicies due to exception. " + e.getMessage(), new Object[0]);
            this.routerMetrics.incrListFederationQueuePoliciesFailedRetrieved();
            throw new YarnException("Unable to listFederationQueuePolicies.");
        }
    }

    public DeleteFederationApplicationResponse deleteFederationApplication(DeleteFederationApplicationRequest request) throws YarnException, IOException {
        String application;
        if (request == null) {
            this.routerMetrics.incrDeleteFederationApplicationFailedRetrieved();
            RouterServerUtil.logAndThrowException("Missing deleteFederationApplication Request.", null);
        }
        if (StringUtils.isBlank((CharSequence)(application = request.getApplication()))) {
            this.routerMetrics.incrDeleteFederationApplicationFailedRetrieved();
            RouterServerUtil.logAndThrowException("ApplicationId cannot be null.", null);
        }
        try {
            long startTime = this.clock.getTime();
            ApplicationId applicationId = ApplicationId.fromString((String)application);
            this.federationFacade.deleteApplicationHomeSubCluster(applicationId);
            long stopTime = this.clock.getTime();
            this.routerMetrics.succeededDeleteFederationApplicationFailedRetrieved(stopTime - startTime);
            return DeleteFederationApplicationResponse.newInstance((String)("applicationId = " + applicationId + " delete success."));
        }
        catch (Exception e) {
            RouterServerUtil.logAndThrowException(e, "Unable to deleteFederationApplication due to exception. " + e.getMessage(), new Object[0]);
            throw new YarnException("Unable to deleteFederationApplication.");
        }
    }

    public GetSubClustersResponse getFederationSubClusters(GetSubClustersRequest request) throws YarnException, IOException {
        if (request == null) {
            this.routerMetrics.incrGetFederationSubClustersFailedRetrieved();
            RouterServerUtil.logAndThrowException("Missing getFederationSubClusters Request.", null);
        }
        Map subClusters = this.federationFacade.getSubClusters(false);
        ArrayList<FederationSubCluster> federationSubClusters = new ArrayList<FederationSubCluster>();
        long startTime = this.clock.getTime();
        for (Map.Entry subCluster : subClusters.entrySet()) {
            SubClusterId subClusterId = (SubClusterId)subCluster.getKey();
            try {
                SubClusterInfo subClusterInfo = (SubClusterInfo)subCluster.getValue();
                long lastHeartBeat = subClusterInfo.getLastHeartBeat();
                Date lastHeartBeatDate = new Date(lastHeartBeat);
                FederationSubCluster federationSubCluster = FederationSubCluster.newInstance((String)subClusterId.getId(), (String)subClusterInfo.getState().name(), (String)lastHeartBeatDate.toString());
                federationSubClusters.add(federationSubCluster);
            }
            catch (Exception e) {
                this.routerMetrics.incrGetFederationSubClustersFailedRetrieved();
                LOG.error("getSubClusters SubClusterId = [%s] error.", (Object)subClusterId, (Object)e);
            }
        }
        long stopTime = this.clock.getTime();
        this.routerMetrics.succeededGetFederationSubClustersRetrieved(stopTime - startTime);
        return GetSubClustersResponse.newInstance(federationSubClusters);
    }

    public DeleteFederationQueuePoliciesResponse deleteFederationPoliciesByQueues(DeleteFederationQueuePoliciesRequest request) throws YarnException, IOException {
        List queues;
        if (request == null) {
            this.routerMetrics.incrDeleteFederationPoliciesByQueuesRetrieved();
            RouterServerUtil.logAndThrowException("Missing deleteFederationQueuePoliciesByQueues Request.", null);
        }
        if (CollectionUtils.isEmpty((Collection)(queues = request.getQueues()))) {
            this.routerMetrics.incrDeleteFederationPoliciesByQueuesRetrieved();
            RouterServerUtil.logAndThrowException("queues cannot be null.", null);
        }
        try {
            long startTime = this.clock.getTime();
            this.federationFacade.deletePolicyConfigurations(queues);
            long stopTime = this.clock.getTime();
            this.routerMetrics.succeededDeleteFederationPoliciesByQueuesRetrieved(stopTime - startTime);
            return DeleteFederationQueuePoliciesResponse.newInstance((String)("queues = " + StringUtils.join((Iterable)queues, (String)COMMA) + " delete success."));
        }
        catch (Exception e) {
            RouterServerUtil.logAndThrowException(e, "Unable to deleteFederationPoliciesByQueues due to exception. " + e.getMessage(), new Object[0]);
            throw new YarnException("Unable to deleteFederationPoliciesByQueues.");
        }
    }

    private QueryFederationQueuePoliciesResponse filterPoliciesConfigurationsByQueue(String queue, Map<String, SubClusterPolicyConfiguration> policiesConfigurations, int pageSize, int currentPage) throws YarnException {
        if (MapUtils.isEmpty(policiesConfigurations)) {
            return null;
        }
        SubClusterPolicyConfiguration policyConf = policiesConfigurations.getOrDefault(queue, null);
        if (policyConf == null) {
            return null;
        }
        ArrayList<FederationQueueWeight> federationQueueWeights = new ArrayList<FederationQueueWeight>();
        FederationQueueWeight federationQueueWeight = this.parseFederationQueueWeight(queue, policyConf);
        federationQueueWeights.add(federationQueueWeight);
        return QueryFederationQueuePoliciesResponse.newInstance((int)1, (int)1, (int)currentPage, (int)pageSize, federationQueueWeights);
    }

    private QueryFederationQueuePoliciesResponse filterPoliciesConfigurationsByQueues(List<String> queues, Map<String, SubClusterPolicyConfiguration> policiesConfigurations, int pageSize, int currentPage) throws YarnException {
        if (MapUtils.isEmpty(policiesConfigurations)) {
            return null;
        }
        ArrayList<FederationQueueWeight> federationQueueWeights = new ArrayList<FederationQueueWeight>();
        for (String queue : queues) {
            FederationQueueWeight federationQueueWeight;
            SubClusterPolicyConfiguration policyConf = policiesConfigurations.getOrDefault(queue, null);
            if (policyConf == null || (federationQueueWeight = this.parseFederationQueueWeight(queue, policyConf)) == null) continue;
            federationQueueWeights.add(federationQueueWeight);
        }
        return this.queryFederationQueuePoliciesPagination(federationQueueWeights, pageSize, currentPage);
    }

    private QueryFederationQueuePoliciesResponse filterPoliciesConfigurations(Map<String, SubClusterPolicyConfiguration> policiesConfigurations, int pageSize, int currentPage) throws YarnException {
        if (MapUtils.isEmpty(policiesConfigurations)) {
            return null;
        }
        ArrayList<FederationQueueWeight> federationQueueWeights = new ArrayList<FederationQueueWeight>();
        for (Map.Entry<String, SubClusterPolicyConfiguration> entry : policiesConfigurations.entrySet()) {
            FederationQueueWeight federationQueueWeight;
            String queue = entry.getKey();
            SubClusterPolicyConfiguration policyConf = entry.getValue();
            if (policyConf == null || (federationQueueWeight = this.parseFederationQueueWeight(queue, policyConf)) == null) continue;
            federationQueueWeights.add(federationQueueWeight);
        }
        return this.queryFederationQueuePoliciesPagination(federationQueueWeights, pageSize, currentPage);
    }

    private QueryFederationQueuePoliciesResponse queryFederationQueuePoliciesPagination(List<FederationQueueWeight> queueWeights, int pageSize, int currentPage) throws YarnException {
        if (CollectionUtils.isEmpty(queueWeights)) {
            return null;
        }
        int startIndex = (currentPage - 1) * pageSize;
        int endIndex = Math.min(startIndex + pageSize, queueWeights.size());
        if (startIndex > endIndex) {
            throw new YarnException("The index of the records to be retrieved has exceeded the maximum index.");
        }
        List<FederationQueueWeight> subFederationQueueWeights = queueWeights.subList(startIndex, endIndex);
        int totalSize = queueWeights.size();
        int totalPage = totalSize % pageSize == 0 ? totalSize / pageSize : totalSize / pageSize + 1;
        return QueryFederationQueuePoliciesResponse.newInstance((int)totalSize, (int)totalPage, (int)currentPage, (int)pageSize, subFederationQueueWeights);
    }

    private FederationQueueWeight parseFederationQueueWeight(String queue, SubClusterPolicyConfiguration policyConf) throws YarnException {
        if (policyConf != null) {
            ByteBuffer params = policyConf.getParams();
            WeightedPolicyInfo weightedPolicyInfo = WeightedPolicyInfo.fromByteBuffer((ByteBuffer)params);
            Map amrmPolicyWeights = weightedPolicyInfo.getAMRMPolicyWeights();
            Map routerPolicyWeights = weightedPolicyInfo.getRouterPolicyWeights();
            float headroomAlpha = weightedPolicyInfo.getHeadroomAlpha();
            String policyManagerClassName = policyConf.getType();
            String amrmPolicyWeight = this.parsePolicyWeights(amrmPolicyWeights);
            String routerPolicyWeight = this.parsePolicyWeights(routerPolicyWeights);
            FederationQueueWeight.checkSubClusterQueueWeightRatioValid((String)amrmPolicyWeight);
            FederationQueueWeight.checkSubClusterQueueWeightRatioValid((String)routerPolicyWeight);
            return FederationQueueWeight.newInstance((String)routerPolicyWeight, (String)amrmPolicyWeight, (String)String.valueOf(headroomAlpha), (String)queue, (String)policyManagerClassName);
        }
        return null;
    }

    protected String parsePolicyWeights(Map<SubClusterIdInfo, Float> policyWeights) {
        if (MapUtils.isEmpty(policyWeights)) {
            return null;
        }
        ArrayList<String> policyWeightList = new ArrayList<String>();
        for (Map.Entry<SubClusterIdInfo, Float> entry : policyWeights.entrySet()) {
            SubClusterIdInfo key = entry.getKey();
            Float value = entry.getValue();
            policyWeightList.add(key.toId() + COLON + value);
        }
        return StringUtils.join(policyWeightList, (String)COMMA);
    }

    private void saveFederationQueuePolicy(FederationQueueWeight federationQueueWeight) throws YarnException {
        String queue = federationQueueWeight.getQueue();
        String policyManagerClassName = federationQueueWeight.getPolicyManagerClassName();
        if (StringUtils.isBlank((CharSequence)queue)) {
            RouterServerUtil.logAndThrowException("Missing Queue information.", null);
        }
        if (StringUtils.isBlank((CharSequence)policyManagerClassName)) {
            RouterServerUtil.logAndThrowException("Missing PolicyManagerClassName information.", null);
        }
        if (!RouterServerUtil.checkPolicyManagerValid(policyManagerClassName, SUPPORT_WEIGHT_MANAGERS)) {
            this.routerMetrics.incrSaveFederationQueuePolicyFailedRetrieved();
            RouterServerUtil.logAndThrowException(policyManagerClassName + "does not support the use of queue weights.", null);
        }
        String amRmWeight = federationQueueWeight.getAmrmWeight();
        FederationQueueWeight.checkSubClusterQueueWeightRatioValid((String)amRmWeight);
        String routerWeight = federationQueueWeight.getRouterWeight();
        FederationQueueWeight.checkSubClusterQueueWeightRatioValid((String)routerWeight);
        String headRoomAlpha = federationQueueWeight.getHeadRoomAlpha();
        FederationQueueWeight.checkHeadRoomAlphaValid((String)headRoomAlpha);
        Map<SubClusterIdInfo, Float> amRMPolicyWeights = this.getSubClusterWeightMap(amRmWeight);
        LOG.debug("amRMPolicyWeights = {}.", amRMPolicyWeights);
        Map<SubClusterIdInfo, Float> routerPolicyWeights = this.getSubClusterWeightMap(routerWeight);
        LOG.debug("routerWeights = {}.", amRMPolicyWeights);
        WeightedPolicyInfo weightedPolicyInfo = new WeightedPolicyInfo();
        weightedPolicyInfo.setHeadroomAlpha(Float.parseFloat(headRoomAlpha));
        weightedPolicyInfo.setAMRMPolicyWeights(amRMPolicyWeights);
        weightedPolicyInfo.setRouterPolicyWeights(routerPolicyWeights);
        SubClusterPolicyConfiguration policyConfiguration = SubClusterPolicyConfiguration.newInstance((String)queue, (String)policyManagerClassName, (ByteBuffer)weightedPolicyInfo.toByteBuffer());
        this.federationFacade.setPolicyConfiguration(policyConfiguration);
    }

    protected Map<SubClusterIdInfo, Float> getSubClusterWeightMap(String policyWeight) throws YarnException {
        String[] policyWeights;
        FederationQueueWeight.checkSubClusterQueueWeightRatioValid((String)policyWeight);
        HashMap<SubClusterIdInfo, Float> result = new HashMap<SubClusterIdInfo, Float>();
        for (String policyWeightItem : policyWeights = policyWeight.split(COMMA)) {
            String[] subClusterWeight = policyWeightItem.split(COLON);
            String subClusterId = subClusterWeight[0];
            SubClusterIdInfo subClusterIdInfo = new SubClusterIdInfo(subClusterId);
            String weight = subClusterWeight[1];
            result.put(subClusterIdInfo, Float.valueOf(weight));
        }
        return result;
    }

    private DeregisterSubClusters deregisterSubCluster(String reqSubClusterId) {
        try {
            SubClusterId subClusterId = SubClusterId.newInstance((String)reqSubClusterId);
            SubClusterInfo subClusterInfo = this.federationFacade.getSubCluster(subClusterId);
            SubClusterState subClusterState = subClusterInfo.getState();
            long lastHeartBeat = subClusterInfo.getLastHeartBeat();
            Date lastHeartBeatDate = new Date(lastHeartBeat);
            DeregisterSubClusters deregisterSubClusters = DeregisterSubClusters.newInstance((String)reqSubClusterId, (String)"NONE", (String)lastHeartBeatDate.toString(), (String)"Normal Heartbeat", (String)subClusterState.name());
            if (subClusterState.isUsable()) {
                LOG.warn("Deregister SubCluster {} in State {} last heartbeat at {}.", new Object[]{subClusterId, subClusterState, lastHeartBeatDate});
                long heartBearTimeInterval = Time.now() - lastHeartBeat;
                if (heartBearTimeInterval - this.heartbeatExpirationMillis < 0L) {
                    boolean deregisterSubClusterFlag = this.federationFacade.deregisterSubCluster(subClusterId, SubClusterState.SC_LOST);
                    if (deregisterSubClusterFlag) {
                        deregisterSubClusters.setDeregisterState("SUCCESS");
                        deregisterSubClusters.setSubClusterState("SC_LOST");
                        deregisterSubClusters.setInformation("Heartbeat Time >= " + this.heartbeatExpirationMillis / 60000L + "minutes");
                    } else {
                        deregisterSubClusters.setDeregisterState("FAILED");
                        deregisterSubClusters.setInformation("DeregisterSubClusters Failed.");
                    }
                }
            } else {
                deregisterSubClusters.setDeregisterState("FAILED");
                deregisterSubClusters.setInformation("The subCluster is Unusable, So it can't be Deregistered");
                LOG.warn("The SubCluster {} is Unusable (SubClusterState:{}), So it can't be Deregistered", (Object)subClusterId, (Object)subClusterState);
            }
            return deregisterSubClusters;
        }
        catch (YarnException e) {
            LOG.error("SubCluster {} DeregisterSubCluster Failed", (Object)reqSubClusterId, (Object)e);
            DeregisterSubClusters deregisterSubClusters = DeregisterSubClusters.newInstance((String)reqSubClusterId, (String)"FAILED", (String)"UNKNOWN", (String)e.getMessage(), (String)"UNKNOWN");
            return deregisterSubClusters;
        }
    }
}

