/*
 * Decompiled with CFR 0.152.
 */
package rx.observables;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.internal.operators.ObservableSplit;
import rx.internal.operators.OnSubscribeInputStream;
import rx.internal.operators.OnSubscribeReader;
import rx.internal.util.RxRingBuffer;
import rx.observables.SyncOnSubscribe;

public class StringObservable {
    public static Observable<byte[]> from(InputStream i) {
        return StringObservable.from(i, 8192);
    }

    public static <R, S extends Closeable> Observable<R> using(final UnsafeFunc0<S> resourceFactory, Func1<S, Observable<R>> observableFactory) {
        return Observable.using((Func0)new Func0<S>(){

            public S call() {
                try {
                    return (Closeable)resourceFactory.call();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        }, observableFactory, (Action1)new Action1<S>(){

            public void call(S resource) {
                try {
                    resource.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }, (boolean)true);
    }

    public static Observable<byte[]> from(InputStream is, int size) {
        return Observable.create((SyncOnSubscribe)new OnSubscribeInputStream(is, size));
    }

    public static Observable<String> from(Reader i) {
        return StringObservable.from(i, 8192);
    }

    public static Observable<String> from(Reader reader, int size) {
        return Observable.create((SyncOnSubscribe)new OnSubscribeReader(reader, size));
    }

    public static Observable<String> decode(Observable<byte[]> src, String charsetName) {
        return StringObservable.decode(src, Charset.forName(charsetName));
    }

    public static Observable<String> decode(Observable<byte[]> src, Charset charset) {
        return StringObservable.decode(src, charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE));
    }

    public static Observable<String> decode(Observable<byte[]> src, final CharsetDecoder charsetDecoder) {
        return src.lift((Observable.Operator)new Observable.Operator<String, byte[]>(){

            public Subscriber<? super byte[]> call(final Subscriber<? super String> o) {
                return new Subscriber<byte[]>(o){
                    private ByteBuffer leftOver;
                    {
                        super(x0);
                        this.leftOver = null;
                    }

                    public void onCompleted() {
                        if (this.process(null, this.leftOver, true)) {
                            o.onCompleted();
                        }
                    }

                    public void onError(Throwable e) {
                        if (this.process(null, this.leftOver, true)) {
                            o.onError(e);
                        }
                    }

                    public void onNext(byte[] bytes) {
                        this.process(bytes, this.leftOver, false);
                    }

                    public boolean process(byte[] next, ByteBuffer last, boolean endOfInput) {
                        ByteBuffer bb;
                        if (o.isUnsubscribed()) {
                            return false;
                        }
                        if (last != null) {
                            if (next != null) {
                                bb = ByteBuffer.allocate(last.remaining() + next.length);
                                bb.put(last);
                                bb.put(next);
                                bb.flip();
                            } else {
                                bb = last;
                            }
                        } else if (next != null) {
                            bb = ByteBuffer.wrap(next);
                        } else {
                            return true;
                        }
                        CharBuffer cb = CharBuffer.allocate((int)((float)bb.limit() * charsetDecoder.averageCharsPerByte()));
                        CoderResult cr = charsetDecoder.decode(bb, cb, endOfInput);
                        cb.flip();
                        if (cr.isError()) {
                            try {
                                cr.throwException();
                            }
                            catch (CharacterCodingException e) {
                                o.onError((Throwable)e);
                                return false;
                            }
                        }
                        this.leftOver = bb.remaining() > 0 ? bb : null;
                        String string = cb.toString();
                        if (!string.isEmpty()) {
                            o.onNext((Object)string);
                        }
                        return true;
                    }
                };
            }
        });
    }

    public static Observable<byte[]> encode(Observable<String> src, String charsetName) {
        return StringObservable.encode(src, Charset.forName(charsetName));
    }

    public static Observable<byte[]> encode(Observable<String> src, Charset charset) {
        return StringObservable.encode(src, charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE));
    }

    public static Observable<byte[]> encode(Observable<String> src, final CharsetEncoder charsetEncoder) {
        return src.map((Func1)new Func1<String, byte[]>(){

            public byte[] call(String str) {
                ByteBuffer bb;
                CharBuffer cb = CharBuffer.wrap(str);
                try {
                    bb = charsetEncoder.encode(cb);
                }
                catch (CharacterCodingException e) {
                    throw new RuntimeException(e);
                }
                return Arrays.copyOfRange(bb.array(), bb.position(), bb.limit());
            }
        });
    }

    public static Observable<String> stringConcat(Observable<String> src) {
        return StringObservable.toString(src.reduce((Object)new StringBuilder(), (Func2)new Func2<StringBuilder, String, StringBuilder>(){

            public StringBuilder call(StringBuilder a, String b) {
                return a.append(b);
            }
        }));
    }

    public static Observable<String> toString(Observable<?> src) {
        return src.map((Func1)new Func1<Object, String>(){

            public String call(Object obj) {
                return String.valueOf(obj);
            }
        });
    }

    public static Observable<String> split(Observable<String> src, String regex) {
        Pattern pattern = Pattern.compile(regex);
        return StringObservable.split(src, pattern);
    }

    public static Observable<String> split(Observable<String> src, Pattern pattern) {
        return Observable.create((Observable.OnSubscribe)new ObservableSplit(src, pattern, RxRingBuffer.SIZE));
    }

    public static Observable<String> join(Observable<String> source, final CharSequence separator) {
        return source.lift((Observable.Operator)new Observable.Operator<String, String>(){

            public Subscriber<String> call(Subscriber<? super String> child) {
                final JoinParentSubscriber parent = new JoinParentSubscriber(child, separator);
                child.add((Subscription)parent);
                child.setProducer(new Producer(){

                    public void request(long n) {
                        if (n > 0L) {
                            parent.requestAll();
                        }
                    }
                });
                return parent;
            }
        });
    }

    public static Observable<String> byLine(Observable<String> source) {
        return StringObservable.split(source, ByLinePatternHolder.BY_LINE);
    }

    public static Observable<String> byCharacter(Observable<String> source) {
        return source.lift((Observable.Operator)new Observable.Operator<String, String>(){

            public Subscriber<? super String> call(final Subscriber<? super String> subscriber) {
                return new Subscriber<String>(subscriber){

                    public void onCompleted() {
                        subscriber.onCompleted();
                    }

                    public void onError(Throwable e) {
                        subscriber.onError(e);
                    }

                    public void onNext(String str) {
                        for (char c : str.toCharArray()) {
                            subscriber.onNext((Object)Character.toString(c));
                        }
                    }
                };
            }
        });
    }

    private static final class ByLinePatternHolder {
        private static final Pattern BY_LINE = Pattern.compile("(\\r\\n)|\\n|\\r|\\u0085|\\u2028|\\u2029");

        private ByLinePatternHolder() {
        }
    }

    private static final class JoinParentSubscriber
    extends Subscriber<String> {
        private final Subscriber<? super String> child;
        private final CharSequence separator;
        private boolean mayAddSeparator;
        private StringBuilder b = new StringBuilder();

        JoinParentSubscriber(Subscriber<? super String> child, CharSequence separator) {
            this.child = child;
            this.separator = separator;
        }

        void requestAll() {
            this.request(Long.MAX_VALUE);
        }

        public void onStart() {
            this.request(0L);
        }

        public void onCompleted() {
            String str = this.b.toString();
            this.b = null;
            if (!this.child.isUnsubscribed()) {
                this.child.onNext((Object)str);
            }
            if (!this.child.isUnsubscribed()) {
                this.child.onCompleted();
            }
        }

        public void onError(Throwable e) {
            this.b = null;
            if (!this.child.isUnsubscribed()) {
                this.child.onError(e);
            }
        }

        public void onNext(String t) {
            if (this.mayAddSeparator) {
                this.b.append(this.separator);
            }
            this.mayAddSeparator = true;
            this.b.append(t);
        }
    }

    public static interface UnsafeFunc0<R>
    extends Callable<R> {
        @Override
        public R call() throws Exception;
    }
}

