/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.CorruptedFrameException;
import java.util.Objects;
import java.util.UUID;

public final class RntbdUUID {
    public static final UUID EMPTY = new UUID(0L, 0L);

    private RntbdUUID() {
    }

    public static UUID decode(byte[] bytes) {
        return RntbdUUID.decode(Unpooled.wrappedBuffer((byte[])bytes));
    }

    public static UUID decode(ByteBuf in) {
        Objects.requireNonNull(in);
        if (in.readableBytes() < 16) {
            String reason = String.format("invalid frame length: %d", in.readableBytes());
            throw new CorruptedFrameException(reason);
        }
        long mostSignificantBits = in.readUnsignedIntLE() << 32;
        mostSignificantBits |= (0xFFFFL & (long)in.readShortLE()) << 16;
        mostSignificantBits |= 0xFFFFL & (long)in.readShortLE();
        long leastSignificantBits = (0xFFFFL & (long)in.readShortLE()) << 48;
        for (int shift = 40; shift >= 0; shift -= 8) {
            leastSignificantBits |= (0xFFL & (long)in.readByte()) << shift;
        }
        return new UUID(mostSignificantBits, leastSignificantBits);
    }

    public static byte[] encode(UUID uuid) {
        byte[] bytes = new byte[8];
        RntbdUUID.encode(uuid, Unpooled.wrappedBuffer((byte[])bytes));
        return bytes;
    }

    public static void encode(UUID uuid, ByteBuf out) {
        long mostSignificantBits = uuid.getMostSignificantBits();
        out.writeIntLE((int)((mostSignificantBits & 0xFFFFFFFF00000000L) >>> 32));
        out.writeShortLE((int)((short)((mostSignificantBits & 0xFFFF0000L) >>> 16)));
        out.writeShortLE((int)((short)(mostSignificantBits & 0xFFFFL)));
        long leastSignificantBits = uuid.getLeastSignificantBits();
        out.writeShortLE((int)((short)((leastSignificantBits & 0xFFFF000000000000L) >>> 48)));
        out.writeShort((int)((short)((leastSignificantBits & 0xFFFF00000000L) >>> 32)));
        out.writeInt((int)(leastSignificantBits & 0xFFFFFFFFL));
    }
}

