/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.physical.data;

import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.io.physical.PhysicalIOConfiguration;
import software.amazon.s3.analyticsaccelerator.util.BlockKey;
import software.amazon.s3.shaded.com.github.benmanes.caffeine.cache.Cache;
import software.amazon.s3.shaded.com.github.benmanes.caffeine.cache.Caffeine;

public class BlobStoreIndexCache {
    protected final Cache<BlockKey, Integer> indexCache;

    public BlobStoreIndexCache(@NonNull PhysicalIOConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        this.indexCache = Caffeine.newBuilder().expireAfterAccess(configuration.getCacheDataTimeoutMilliseconds(), TimeUnit.MILLISECONDS).weigher((blockKey, blockSize) -> blockSize).maximumWeight(configuration.getMemoryCapacityBytes()).build();
    }

    public void put(BlockKey blockKey, int range) {
        this.indexCache.put(blockKey, range);
    }

    public boolean contains(BlockKey blockKey) {
        return this.indexCache.asMap().containsKey(blockKey);
    }

    public Integer getIfPresent(BlockKey blockKey) {
        return this.indexCache.getIfPresent(blockKey);
    }

    public void recordAccess(BlockKey blockKey) {
        if (!this.contains(blockKey)) {
            this.put(blockKey, blockKey.getRange().getLength());
        } else {
            this.getIfPresent(blockKey);
        }
    }

    public void cleanUp() {
        if (this.indexCache != null) {
            this.indexCache.invalidateAll();
            this.indexCache.cleanUp();
        }
    }

    public long getMaximumWeight() {
        return this.indexCache.policy().eviction().get().getMaximum();
    }

    public long getCurrentWeight() {
        return this.indexCache.policy().eviction().get().weightedSize().getAsLong();
    }
}

